#RunIT-QT Browser Copyright (c) 2015 JJ Posti <techtimejourney.net> 
#RunIT-QT  comes with ABSOLUTELY NO WARRANTY; 
#for details see: http://www.gnu.org/copyleft/gpl.html. 
#This is free software, and you are welcome to redistribute it under 
#GPL Version 2, June 1991
#This is the 0.5 version made with Python and QT5 ")
from PyQt5 import QtCore, QtGui, QtWidgets, QtWebKitWidgets
from PyQt5.QtCore import QUrl, Qt
from PyQt5.QtGui import QIcon, QPixmap, QPainter
from PyQt5.QtWidgets import QApplication, QMainWindow, QWidget, QVBoxLayout, QSplitter, QToolButton, QLineEdit
from PyQt5.QtWebKit import QWebSettings
from PyQt5.QtWebKitWidgets import QWebPage, QWebView, QWebInspector
from PyQt5.QtPrintSupport import QPrintPreviewDialog, QPrinter
import os, sys, subprocess
from subprocess import Popen 
try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    def _fromUtf8(s):
        return s
try:
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig)

class NewPage(QWebPage):
    def __init__(self, parent=None):
        super(NewPage, self).__init__(parent)
          
    def userAgentForUrl(self, url):
        ''' Returns a User Agent that will be seen by the website. '''
        return "Mozilla/5.0 (X11; Linux; rv:10.0) Gecko/20100101 Firefox/50.0"
    def triggerAction(self, action, checked=False):
        if action == QWebPage.OpenLinkInNewWindow:
            self.createWindow(QWebPage.WebBrowserWindow)

        return super(NewPage, self).triggerAction(action, checked)

class NewWindow(QWebView):
    def __init__(self, parent=None):
        super(NewWindow, self).__init__(parent)

        self.NewPage = NewPage(self)

        self.setPage(self.NewPage)

    def createWindow(self, windowType):
        if windowType == QWebPage.WebBrowserWindow:
            self.webView = NewWindow()
            self.webView.setAttribute(Qt.WA_DeleteOnClose, True)
            return self.webView
        return super(NewWindow, self).createWindow(windowType)

class Ui_MainWindow(QMainWindow):
    def __init__(self, *args, **kwargs):
        super(Ui_MainWindow, self).__init__(*args, **kwargs)    
#Download functions
    def downloads(self,widget):
        add=self.address.text()
        home=os.getenv("HOME")
        print home
        os.chdir(home)
        downloaded = 'Downloaded_files' 

        if not os.path.exists(downloaded):
			os.makedirs(downloaded)
        os.chdir(downloaded)
        downloads=subprocess.Popen(['wget', add])
        downloads
        
    def loadings(self):
        subprocess.Popen(['notify-send', '-t', '3500', 'Downloading a file to Downloaded_files folder'])
        
#Printer function
    def handlePreview(self):
        dialog = QPrintPreviewDialog()
        dialog.paintRequested.connect(self.handlePaintRequest)
        dialog.exec_()

    def handlePaintRequest(self, printer):
        self.web.render(QPainter(printer))	

#Play in Vlc function
    def vlcs(self):
        site=(self.address.text())
        subprocess.Popen(['vlc', site])
#Back function
    def backs(self,url):
        goback=self.web.back()
	
#Forward function	
    def forwards(self,url):	
        self.web.forward()       

#Reload function
    def reloads(self):	
        self.web.reload()
        
#Home page function
    def homes(self):
        self.home = "http://techtimejourney.net/audax"
        self.address.setText(self.home)
        self.web.load(QUrl("http://techtimejourney.net/audax"))       
#Zooms   
    def zoomins(self):
        self.web.setZoomFactor(self.web.zoomFactor()+.2)

    def zoomouts(self):
        self.web.setZoomFactor(self.web.zoomFactor()-.2)
        
#Navigation to address
    def navigate(self):
        url=self.address.text()
        if url.startswith('http://'):
            change=str(url)
            self.address.setText(change)
            self.web.load(QUrl(change))
        
        elif url.startswith('https://'):
            change=str(url)
            self.address.setText(change)
            self.web.load(QUrl(change))
            
        else:
            add="http://" + url
            change=str(add)
            self.address.setText(change)
            self.web.load(QUrl(change))                 			        
##################################
#Search engines & default (Now. Privatelee)

    def extra(self):
        search=self.Search.text()
        text=self.switch_2.text()
        if text == ('wolf'):
#Wolfram Alpha search
            adds1="https://www.wolframalpha.com/input/?i=" + search 
            self.web.load(QUrl(adds1))
            print adds1
        
        elif text == ('wiki'):
#Wikipedia search (english)        
            adds1="https://en.wikipedia.org/w/index.php?title=Special:Search&profile=default&fulltext=Search&search=" + search 
            self.web.load(QUrl(adds1))
            print adds1

        elif text == ('tube'):
#Youtube search (english)        
            adds1="https://www.youtube.com/results?search_query=" + search 
            self.web.load(QUrl(adds1))
            print adds1

        else:
            adds1="https://privatelee.com/search/?q=" + search 
            self.web.load(QUrl(adds1))
            print adds1
                                    			               
############################################
#Bookmark function
    def bookmarks(self,widget):
        home=os.getenv("HOME")
        print home
        site=str(self.address.text())
        os.chdir(home) 
        f = open('.bookmarks.txt', 'a')
        f.write(site)
        f.write('\n')
        f.write('\n')
        f.close()
        subprocess.Popen(['notify-send', '-t', '3500', 'Bookmark created'])
        print site

#Open bookmarks file
    def bookopen(self,widget):
    	home=os.getenv("HOME")
        print home
        home=os.getenv("HOME")
        os.chdir(home)
        head="file:///"
        books=".bookmarks.txt"
        adds=self.address.setText(head + home + '/' + books)
        adda=self.address.text()
        self.web.load(QUrl(adda))    
                
    def setupUi(self, MainWindow):
        MainWindow.setObjectName(_fromUtf8("MainWindow"))
        MainWindow.resize(1506, 685)
        self.centralwidget = QWidget(MainWindow)
        self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
        self.verticalLayout_2 = QVBoxLayout(self.centralwidget)
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        self.splitter = QSplitter(self.centralwidget)
        self.splitter.setGeometry(QtCore.QRect(0, 20, 1491, 32))
        self.splitter.setOrientation(QtCore.Qt.Horizontal)
        self.splitter.setObjectName(_fromUtf8("splitter"))
        
#Layout     
        self.vertical = QVBoxLayout()
        self.vertical.addStretch(1)

#Back        
        self.back = QToolButton(self.splitter)
        icon = QIcon()
        icon.addPixmap(QPixmap(_fromUtf8(":/icons/back.png")), QIcon.Normal, QIcon.Off)
        self.back.setIcon(icon)
        self.back.setObjectName(_fromUtf8("back"))
        self.back.setToolTip('Go Back')
        self.back.clicked.connect(self.backs)
        self.vertical.addWidget(self.back)
        
#Address        
        self.address = QLineEdit(self.splitter)
        self.address.setObjectName(_fromUtf8("lineEdit"))
        self.address.setPlaceholderText("Type address")
        self.address.setFixedSize(500, 30)
        self.address.returnPressed.connect(self.navigate)
        self.vertical.addWidget(self.address)
        
#Forward        
        self.forward = QToolButton(self.splitter)
        icon1 = QIcon()
        icon1.addPixmap(QPixmap(_fromUtf8(":/icons/forward.png")), QIcon.Normal, QIcon.Off)
        self.forward.setIcon(icon1)
        self.forward.setObjectName(_fromUtf8("forward"))
        self.forward.setToolTip('Go Forward')
        self.forward.clicked.connect(self.forwards)
        self.vertical.addWidget(self.forward)

#Home        
        self.home = QToolButton(self.splitter)
        icon2 = QIcon()
        icon2.addPixmap(QPixmap(_fromUtf8(":/icons/home.png")), QIcon.Normal, QIcon.Off)
        self.home.setIcon(icon2)
        self.home.setObjectName(_fromUtf8("home"))
        self.home.setToolTip('Go Home')
        self.home.clicked.connect(self.homes)
        self.vertical.addWidget(self.home)
        
#Reload        
        self.reloading = QToolButton(self.splitter)
        icon3 = QIcon()
        icon3.addPixmap(QPixmap(_fromUtf8(":/icons/reload.png")), QIcon.Normal, QIcon.Off)
        self.reloading.setIcon(icon3)
        self.reloading.setObjectName(_fromUtf8("reload"))
        self.reloading.setToolTip('Reload Page')
        self.reloading.clicked.connect(self.reloads)
        self.vertical.addWidget(self.reloading)        
#Vlc        
        self.vlc = QToolButton(self.splitter)
        icon4 = QIcon()
        icon4.addPixmap(QPixmap(_fromUtf8(":/icons/vlc_play.png")), QIcon.Normal, QIcon.Off)
        self.vlc.setIcon(icon4)
        self.vlc.setObjectName(_fromUtf8("vlc"))
        self.vlc.setToolTip('Play address in Vlc')
        self.vlc.clicked.connect(self.vlcs)
        self.vertical.addWidget(self.vlc)        
#Bookmark        
        self.bookmark = QToolButton(self.splitter)
        icon5 = QIcon()
        icon5.addPixmap(QPixmap(_fromUtf8(":/icons/bookmark.png")), QIcon.Normal, QIcon.Off)
        self.bookmark.setIcon(icon5)
        self.bookmark.setObjectName(_fromUtf8("bookmark"))
        self.bookmark.setToolTip('Bookmark addressbar location')
        self.bookmark.clicked.connect(self.bookmarks)
        self.vertical.addWidget(self.bookmark)        
#Open Bookmarks        
        self.see_bookmark = QToolButton(self.splitter)
        icon6 = QIcon()
        icon6.addPixmap(QPixmap(_fromUtf8(":/icons/seebook.png")), QIcon.Normal, QIcon.Off)
        self.see_bookmark.setIcon(icon6)
        self.see_bookmark.setObjectName(_fromUtf8("see_bookmark"))
        self.see_bookmark.setToolTip('See Bookmarks')
        self.see_bookmark.clicked.connect(self.bookopen)
        self.vertical.addWidget(self.see_bookmark)        
#Download        
        self.download = QToolButton(self.splitter)
        icon7 = QIcon()
        icon7.addPixmap(QPixmap(_fromUtf8(":/icons/download.png")), QIcon.Normal, QIcon.Off)
        self.download.setIcon(icon7)
        self.download.setObjectName(_fromUtf8("download"))
        self.download.setToolTip('Download file from location')
        self.download.clicked.connect(self.downloads)
        self.download.clicked.connect(self.loadings)
        self.vertical.addWidget(self.download)        
#Search Switch        
        self.switch_2 = QLineEdit(self.splitter)
        self.switch_2.setObjectName(_fromUtf8("switch_2"))
        self.switch_2.setPlaceholderText("Switch")
        self.switch_2.setFixedSize(100, 30)
        self.switch_2.setToolTip('wiki = Wikipedia,  tube = Youtube,  wolf = Wolfram Alpha. Empty = Privatelee (default)')
        self.switch_2.returnPressed.connect(self.extra)
        self.vertical.addWidget(self.switch_2)        
#Search        
        self.Search = QLineEdit(self.splitter)
        self.Search.setObjectName(_fromUtf8("Search"))
        self.Search.setPlaceholderText("Search something")
        self.Search.setFixedSize(300, 30)
        self.Search.returnPressed.connect(self.extra)
        self.vertical.addWidget(self.Search)
#Printing        
        self.printing = QToolButton(self.splitter)
        icon8 = QIcon()
        icon8.addPixmap(QPixmap(_fromUtf8(":/icons/print.png")), QIcon.Normal, QIcon.Off)
        self.printing.setIcon(icon8)
        self.printing.setObjectName(_fromUtf8("print"))
        self.printing.setToolTip('Print')
        self.printing.clicked.connect(self.handlePreview)
        self.vertical.addWidget(self.printing)
        
#Zoom +        
        self.zoom_in = QToolButton(self.splitter)
        icon9 = QIcon()
        icon9.addPixmap(QPixmap(_fromUtf8(":/icons/zoom-in.png")), QIcon.Normal, QIcon.Off)
        self.zoom_in.setIcon(icon9)
        self.zoom_in.setObjectName(_fromUtf8("zoom_in"))
        self.zoom_in.setToolTip('Zoom +')
        self.zoom_in.clicked.connect(self.zoomins)
        self.vertical.addWidget(self.zoom_in)

#Zoom -        
        self.zoom_out = QToolButton(self.splitter)
        icon10 = QIcon()
        icon10.addPixmap(QPixmap(_fromUtf8(":/icons/zoom-out.png")), QIcon.Normal, QIcon.Off)
        self.zoom_out.setIcon(icon10)
        self.zoom_out.setObjectName(_fromUtf8("zoom_out"))
        self.zoom_out.setToolTip('Zoom -')
        self.zoom_out.clicked.connect(self.zoomouts)
        self.vertical.addWidget(self.zoom_out)

#Web browser        
        self.web = NewWindow(self.centralwidget)
        self.web.titleChanged = self.setWindowTitle
        self.web.urlChanged.connect(lambda x: self.address.setText(x.toString()))        
        self.web.load(QUrl("http://techtimejourney.net/audax"))
        self.web.setGeometry(QtCore.QRect(0, 59, 1501, 651))
        self.web.setObjectName(_fromUtf8("kwebview"))
        MainWindow.setCentralWidget(self.centralwidget)
#Adding to layout
        self.verticalLayout_2.addWidget(self.splitter)
        self.verticalLayout_2.addWidget(self.web)
      
#Web inspector
        self.inspector = QWebInspector()

        self.web.page().settings().setAttribute(
            QWebSettings.DeveloperExtrasEnabled, True
        )
        self.inspector.setPage(self.web.page())
        
#More Browser settings
        self.web.page().settings().setAttribute(QWebSettings.JavascriptEnabled, True)
        self.web.page().settings().setAttribute(QWebSettings.LocalContentCanAccessFileUrls, True)
        self.web.page().settings().setAttribute(QWebSettings.LocalContentCanAccessRemoteUrls, True)
        self.web.page().settings().setAttribute(QWebSettings.LocalStorageEnabled, True)
        self.web.page().settings().setAttribute(QWebSettings.PluginsEnabled, True)
        self.web.page().settings().setAttribute(QWebSettings.PrivateBrowsingEnabled, False)
        self.web.page().settings().setAttribute(QWebSettings.SpatialNavigationEnabled, True)
        self.web.page().settings().setAttribute(QWebSettings.AutoLoadImages, True)
        self.web.page().settings().setAttribute(QWebSettings.AcceleratedCompositingEnabled, True)
####################################################################################################        
        self.retranslateUi(MainWindow)
        QtCore.QMetaObject.connectSlotsByName(MainWindow)        
        
    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(_translate("MainWindow", "RunIT-QT", None))
        self.back.setText(_translate("MainWindow", "Back", None))
        self.forward.setText(_translate("MainWindow", "Forward\n"
"", None))
        self.home.setText(_translate("MainWindow", "Home", None))
        self.reloading.setText(_translate("MainWindow", "Reload\n"
"", None))
        self.vlc.setText(_translate("MainWindow", "Vlc Play", None))
        self.bookmark.setText(_translate("MainWindow", "Bookmarkl", None))
        self.see_bookmark.setText(_translate("MainWindow", "See bookmarks", None))
        self.download.setText(_translate("MainWindow", "Download", None))
        self.printing.setText(_translate("MainWindow", "Print", None))
        self.zoom_in.setText(_translate("MainWindow", "Zoom+", None))
        self.zoom_out.setText(_translate("MainWindow", "Zoom-", None))
        self.setLayout(self.vertical)

##################################
#Icons Using Adwaita icons
##################################

qt_resource_data = "\
\x00\x00\x04\xe5\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x0d\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x50\x72\x69\x6e\x74\x65\x72\x08\
\x26\xb2\x13\x00\x00\x00\x17\x74\x45\x58\x74\x41\x75\x74\x68\x6f\
\x72\x00\x4c\x61\x70\x6f\x20\x43\x61\x6c\x61\x6d\x61\x6e\x64\x72\
\x65\x69\xdf\x91\x1a\x2a\x00\x00\x04\x26\x49\x44\x41\x54\x48\x89\
\xdd\x96\xcb\x6b\x9c\x55\x18\xc6\x7f\xdf\x6d\x66\x32\x93\x99\xcc\
\x4c\x32\x99\x98\x98\x26\x36\x4d\xdb\xc4\x34\xb5\xd6\xda\x85\xa2\
\x88\x94\xc1\x85\x08\x52\x15\x2c\xad\xb8\xa8\x88\xee\xa4\x3b\x51\
\x97\x45\x04\x11\x5c\x08\xfe\x03\x6e\x14\xdc\x54\xc9\xa2\x88\x85\
\x6a\xa0\x89\x49\x9b\x36\x6d\xa2\x6d\xd3\x4b\xda\xa4\x33\x93\xcc\
\xed\x9b\x6f\xe6\x9b\x73\x71\x11\x33\x24\xd8\x82\xb5\x76\xe3\xb3\
\x79\x0f\xe7\xf0\x3e\xcf\xcb\x7b\xe3\x18\x99\x4c\x86\x87\x09\xf3\
\xa1\xb2\xff\x2f\x04\xec\xf5\x43\xae\x54\xbe\x2c\xa5\xda\xf2\x5f\
\x90\x1a\x06\x79\x53\x34\xb6\x76\x74\x74\x54\x6d\x80\xdb\x85\xc2\
\xa3\xad\xa1\x70\xd7\x91\x43\xaf\xd9\x43\x43\xc3\x8c\x0c\x8f\xfc\
\x2b\xe2\xf9\xf9\x39\x26\xa6\x26\xf8\xee\xfb\x13\xa1\x7c\xae\x38\
\x04\x4c\xda\x00\x86\x60\x38\xdd\x95\x16\x5a\x2b\xa4\x14\xb8\xd5\
\x0a\xc7\x3f\x3d\x4e\x61\xb5\x70\x4f\xb2\x62\xb1\x48\x34\x1a\xc5\
\x34\x4d\xe2\x89\x38\xc7\x3e\x38\x86\x36\x34\x4a\x2a\xd2\xa9\x94\
\xb5\xb2\x52\x78\x1c\x98\x5c\xab\x81\x65\x8c\x74\x77\xa5\xc2\x5a\
\x6b\x02\x8e\xc3\x95\xab\x97\xc9\x65\x73\xec\xda\x35\x82\x10\xe2\
\x6f\x56\x08\x81\x94\x0a\xdf\xf7\x11\x42\x90\xcf\xe5\xb9\x93\x5d\
\xc6\x71\x2c\x94\x52\xa4\x52\xed\x11\xcb\x34\x77\xc3\x5f\x35\x08\
\x38\xf6\xfe\x74\x67\xca\x96\x52\x62\xd9\x26\xf9\xd5\x22\x00\x53\
\x53\xd3\x77\xb5\x8e\xe3\x30\x3a\x3a\xca\xde\xa7\x9e\x64\xc7\x8e\
\xed\x38\x8e\x83\xe3\x38\x54\xca\x65\x94\x92\xb4\x27\x13\x86\xed\
\xd8\xfb\x9a\x02\x26\x8c\xa6\x3b\x53\x28\x25\x71\x82\x0e\xdb\x06\
\x07\xf8\xe8\x93\x0f\xd1\x5a\xdf\x35\x3d\xa6\x69\x61\x9a\xc6\xa6\
\x3b\x21\x1b\xd8\x01\x9b\x40\x30\x40\x67\x38\x82\x52\x7a\x67\x53\
\xa0\x21\x55\xdf\xe0\xe0\x00\x55\xaf\xca\xae\xe1\x3d\x58\x96\x75\
\x7f\xd5\xdd\x80\x1b\xd7\x6f\xd2\xd2\xd2\x82\x52\x2a\x99\xcb\xe5\
\x1c\x1b\x40\x29\xe5\x9c\x9b\x39\x4f\xf6\xce\x1d\xd2\x9d\x5d\x0f\
\x24\x30\x3e\x3e\x4e\x5b\x2c\x0e\x40\x3e\x1a\xb5\x6c\x00\xad\x35\
\x73\x73\xbf\xb3\xbc\xbc\xc4\x8b\x95\xd2\x03\x09\x5c\xba\x34\x4f\
\x5b\xac\xad\x99\xde\xe6\xa0\x55\x5c\x17\xdf\x6f\x10\x89\x44\xb0\
\x6d\x9b\xbd\x4f\xec\x07\xc0\xd8\x38\xeb\x1a\xee\x56\x96\x93\x3f\
\x8d\x11\x4f\xac\x45\xdd\x10\x82\x8a\xeb\x36\xdf\x0c\xc0\xd8\xbd\
\x6f\xbf\xdf\xb7\xa5\xdb\x16\x8d\x06\xcb\xd9\x55\x84\x10\xbc\x7d\
\xe8\x0d\x5e\x79\xf5\x65\x7e\xb9\xf6\x2d\x65\x3f\xdf\x74\x08\x5a\
\xad\xec\xed\x79\x89\x64\x4b\x0f\x00\x3f\xfc\x78\x82\x2f\xbf\xfa\
\x1a\x27\x10\x20\x9d\x4a\xa0\x94\xc6\xb2\x2c\x16\x6f\x67\x65\x56\
\x89\x98\x05\x98\xe9\x47\xba\xdf\x2f\x95\xdd\x90\x6d\x9a\x66\x5d\
\x08\x06\xfa\x7b\x39\x7c\xe4\x30\x75\x27\xc7\x68\xcf\xf3\x44\x5b\
\xda\x09\x3a\x21\x22\xa1\x28\xb1\x70\x92\xee\xf8\x56\x62\xe1\x24\
\x81\x80\x43\x32\xd9\xce\xc4\xe4\x04\xb5\x5a\x1d\x21\x24\x52\x2a\
\x72\xf9\x82\x44\x6b\x57\xe4\x73\x9f\x99\x00\x97\x66\xce\x1e\x10\
\x8d\x86\x9f\x5b\x2d\xd2\x91\x4c\x12\x8d\xc5\x48\xc4\x13\xf4\x74\
\x6c\xa3\x66\x94\x08\x85\x82\xec\xec\x7e\x9a\xe7\xb6\xbf\x4e\x3a\
\xde\xc7\x92\xf7\x07\x66\x40\x13\x89\xb4\x92\x48\x24\x08\x87\xc3\
\x74\xa6\x3a\x28\x96\x5d\x0a\xa5\x0a\x52\x4a\x39\x7b\x61\xe6\xc0\
\xc2\xc2\x42\xc3\x04\xb4\xef\xfb\x8b\x17\xcf\x4d\xbf\xb3\x92\xcb\
\x2e\x0c\x0e\xf4\x23\x85\x20\x12\x09\xd3\x16\xea\x20\x15\xe9\x65\
\x4b\x62\x98\xd5\xea\x2d\xb2\x95\x6b\xa4\x5a\x7b\x59\x2a\x5d\xe1\
\xd4\xe5\x6f\x00\x4d\xb8\x25\x84\xe7\x79\x3c\xd6\xd7\x4b\xa9\xb0\
\x9a\x3f\x3f\xfd\xdb\xc7\xb3\x67\xa7\x0e\x36\x3c\xef\x0a\xa0\xcc\
\x4c\x26\xa3\x81\x92\x94\xf2\x62\x28\x14\x8c\x0f\x0c\x6c\x25\x9f\
\x5f\xc1\xb6\x2c\x5c\xd7\xc5\xaf\x09\x44\x5d\xd3\x17\xdd\x43\x7b\
\xa0\x9f\x56\x33\xc5\x0b\xfd\x6f\xf1\x6c\xef\x9b\xb8\xae\x8b\x52\
\x9a\x42\xa1\xc4\xd0\xf0\x4e\x6c\xdb\x8e\x28\x21\x7e\x96\x52\x9e\
\x02\x56\x33\x99\x8c\x5e\xef\x22\x09\x68\xaf\xea\xc5\x96\x6e\x2f\
\xb2\x70\xf5\x2a\x47\xdf\x3d\x4a\x6b\x6b\xf4\x9e\xed\xd8\xfe\xcc\
\x7b\x98\xa6\xc5\x8d\x93\x9f\xb3\x78\xf3\x06\x17\x67\x67\xa9\x79\
\xd5\x20\xb6\x2d\x10\xc2\xcd\x64\x32\x72\x53\x9b\x02\x56\xbd\x56\
\x33\x4e\x9d\x3e\x43\xb9\x5c\x41\x34\x24\xf5\x5a\x6d\x13\xe9\xc6\
\xd5\xb1\x78\xf2\x0b\xb4\x56\xf8\x7e\x9d\x4a\xb9\xc2\xe9\xf1\x49\
\x6a\x5e\x0d\x1b\x1c\xb1\xc1\x67\xa3\x80\x57\xf7\xeb\xde\xcc\xf4\
\x54\xd8\x30\x4d\x7e\x1d\x3f\xa3\x0d\x63\xf3\xbe\xb9\x17\x3c\xaf\
\x6a\xcc\xcd\x5e\x00\x68\x08\x21\x2a\x40\x33\x92\x75\x01\x0d\xdc\
\xaa\x14\x8b\x07\x81\x7e\xc0\x2e\x17\x0a\xea\x1f\xb1\xaf\xc1\x64\
\x2d\xcd\xd7\x81\x6b\x40\xd3\xd7\x58\xff\xb6\x8c\x8d\x8d\x59\x40\
\x0b\x10\x64\x6d\x00\xef\x17\x1a\xf0\x81\xea\x7a\xfe\x01\xfe\x04\
\x62\xc8\xe5\xf6\x2a\x05\x90\x05\x00\x00\x00\x00\x49\x45\x4e\x44\
\xae\x42\x60\x82\
\x00\x00\x04\x54\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x03\xb2\x49\x44\x41\
\x54\x48\x89\xb5\x96\x5f\x48\x1c\x47\x1c\xc7\xbf\x33\xb7\x97\xf3\
\xf6\xd6\x52\x29\x91\xb5\xf4\x21\xd5\xfe\x59\x42\xdf\xfa\xe4\x43\
\x91\xd5\x5a\xa3\x59\x6c\x15\x0b\xfd\x4f\x1e\x8a\xc4\x70\x88\x70\
\x45\xa3\x7d\x38\xcc\x43\xcc\x3d\xd8\xf6\x41\x08\x09\x2d\x3d\x28\
\x74\xc9\x83\x60\xf1\xea\x1f\x04\xb7\xe6\xa1\xb6\x85\x18\xdb\x40\
\x7a\x26\x8d\x95\xf6\xd4\x6d\x09\xf8\x27\xa7\x7b\xbb\x33\xb3\xdb\
\x87\xd8\x94\x83\x24\x5c\x6c\x1c\x98\x97\x99\xe1\xf3\x61\x7e\xf3\
\x9b\x99\x1f\x09\x82\x00\x07\xd9\xe8\x81\xd2\x01\x48\xa5\x2c\xba\
\x34\x76\xa9\x06\x42\x9c\x09\x7c\xbf\xce\x17\x62\xdc\x0b\x05\x83\
\x27\xde\x3c\x61\x3f\x16\xc1\xe8\xa8\xa9\x91\x00\x56\x53\x63\x8b\
\x1a\x0e\x1f\xc2\xd2\x8d\xeb\x27\xaf\x5d\x5b\x64\x00\xba\x4b\x11\
\x3c\x34\x44\xe6\xa8\xa9\x31\xdf\xb7\x5a\x8e\x19\xaa\xa2\x94\x43\
\x08\x86\xea\x67\x6b\xe0\x09\xbf\xbd\x14\xf8\x43\x05\xe6\xa8\xa9\
\x81\x73\xcb\x68\x6e\x55\xa3\x51\x19\xf9\xfc\x36\x28\x0d\x61\x6d\
\x6d\x0d\x3e\x67\x63\xa5\x0a\xee\x1b\x22\xd3\x4c\x6b\x3e\xa1\x56\
\xeb\xf1\xb6\x7b\x70\x49\x0a\xc3\xfe\xcb\xc6\xe5\xef\xe7\x6c\x9f\
\xb1\x4f\xf6\xbd\x03\xd3\x4c\x6b\x02\xb0\x5a\x8f\xbf\xa1\xca\x72\
\x31\x7c\x66\x76\xda\x66\xc2\xd7\xbb\xba\x7a\x96\xf7\x25\x48\x9b\
\x69\x8d\xf9\x81\xd5\x6a\xb4\xab\xb2\x1c\xfb\x0f\x6e\xaf\x63\x7a\
\x66\xd2\xe6\x85\x82\x1e\xef\x8c\x67\x4b\x85\x03\x00\xf9\xf7\xa2\
\xa5\xcd\xb4\x46\x84\xb0\xda\x5e\xef\x50\x63\xb2\x52\x04\x9f\x9a\
\x99\xb4\x03\xce\x74\x49\x8a\x15\xa4\x08\x49\x71\xc6\x0d\x04\xc8\
\x14\x1c\xd6\xd7\xd3\xd3\xb3\x72\xee\xb3\x73\x47\xca\x68\x38\xe5\
\x71\x66\x50\x42\x32\x3b\x6e\xa1\x2f\x79\x3a\xb9\x72\x6f\x07\xe9\
\xaf\xd3\xcf\x83\xf1\xd9\xb6\xd6\x62\xf8\xba\xbd\x8e\x89\xe9\x09\
\xbb\xc0\x99\x1e\x8f\x27\xb2\x44\x42\xaa\xee\x15\xbd\xa3\xf3\xc3\
\x2e\xb9\xbe\xfe\xd5\x0e\x1a\x46\x0a\x00\x22\x90\x52\x4d\xaf\x35\
\x77\x7c\xd4\xd3\x2b\xb7\x1c\x33\x3a\x0e\x91\x50\xaa\x28\x44\xc2\
\xf3\xbe\x3a\x7a\xf4\xa5\x2a\x59\x8e\x61\x7b\x7b\x13\x94\x86\x40\
\x69\x08\xd3\x33\x93\x10\x1e\xef\x4a\xc4\x13\x59\x00\xe0\xcc\x33\
\x6a\xaa\x9f\xa3\x8e\xb3\x8b\xca\xc3\x95\xd4\xf5\x0a\x06\x00\xb8\
\x9e\x6b\xbc\xf8\x82\x46\x1d\x67\x17\x55\x6a\x15\x75\x5d\xd7\x28\
\x12\x70\x37\x78\x7f\xe1\xea\xc2\xfa\xad\xe5\xdf\x10\x0a\x85\xe0\
\x38\xbb\x08\x87\x25\xbc\xfb\xd6\x07\x08\x88\x7f\x7e\x68\x78\x48\
\x03\x00\x3f\xf0\x33\x0b\x57\xaf\xf8\x5b\x5b\x9b\xf8\x6e\x6e\x56\
\x10\x9f\x64\x00\x80\x80\x64\x7e\xfc\xe9\x07\x7f\x63\x63\x03\xd3\
\x33\x53\x02\xe4\xee\x78\xd1\x19\x8c\x5c\x1c\xd1\x02\x2e\xac\x86\
\xfa\x06\x55\xad\x54\xe1\x38\xbb\xa8\xac\x54\x91\xcf\xe7\x71\xf1\
\x8b\x0b\xb6\xcf\x3c\x9d\x44\x23\x85\x30\x68\x8a\x31\x6e\x50\x4a\
\x32\x0e\xf3\xfa\x92\xa7\x93\x2b\x83\x83\xfd\x47\x68\x28\x92\xf2\
\x98\x67\x10\x42\x32\xcc\xdd\xed\x1b\x1a\xfa\x74\xa5\x48\x00\x00\
\xc3\x23\xc3\x1a\x11\x81\xd5\xd8\xd0\xa8\xaa\xaa\x8a\x9d\x9d\x3c\
\x9e\xae\x7a\x06\x77\xf2\x79\x9c\xbf\x30\x62\x0b\xcf\xd5\x93\xc9\
\xb3\x8f\x94\x45\x45\x69\x9a\x88\x27\xb2\x2e\x67\xfa\xc4\xd4\x84\
\x9d\x5b\xcd\x21\x12\x89\x62\xe5\x8f\xdf\x11\x8b\xc5\x70\xb2\xf3\
\x94\xea\x83\x5a\x03\x03\x03\xda\xbe\x05\x00\xd0\x9f\xe8\xcf\xfa\
\xcc\xd3\xbf\x9d\xc8\xd8\xb9\xd5\x3f\x21\x47\x65\xdc\x5a\xbe\x09\
\x25\xa6\x20\x7e\xaa\x5b\x0d\x28\xb7\x7a\x7b\xbb\x6b\xf6\x2d\x00\
\x80\xfe\xfe\x64\x56\x78\xae\x3e\x9e\xc9\xd8\xb9\x5c\x0e\x4a\x4c\
\xc1\xd2\x8d\x5f\xa1\x28\x0a\xde\x79\xfb\x3d\xd5\x13\xe4\xcc\xff\
\x12\x00\x40\x32\x79\x36\xcb\x5d\x47\xff\x66\x7c\xec\xae\xa4\xbc\
\x1c\x4b\x37\xaf\x23\x5a\x56\x06\xc1\x59\x5d\xa9\x82\xfb\x3e\x76\
\x84\x10\x09\x40\x05\x00\x56\x5b\x5b\xdb\xe5\x14\xdc\xcf\x9b\x9b\
\x9a\x9e\xaa\xae\xae\xc1\xcf\xbf\x2c\x22\x7f\x27\x3f\x47\x08\x39\
\x0c\x60\x23\x08\x02\xfe\xc8\x02\x00\x0a\x80\x18\x80\x27\xe6\xe7\
\xe7\xb7\x6e\xdf\xfe\xfb\xe3\xb5\xdc\x6a\x7b\x45\xc5\x93\x2f\x6f\
\x6e\x6e\x5f\x5e\x5c\xb8\xf2\xe5\xde\x3c\x03\xb0\xf9\x30\x01\x79\
\xd0\xa7\x4f\x08\x21\x00\x22\x00\xca\xf6\xba\x04\x80\x03\x28\xec\
\x75\x37\x28\xa1\x62\x78\xa0\xe0\x71\xb5\x03\xaf\x2a\xfe\x01\xde\
\x9e\xcc\xe8\x8b\xcc\xb6\x66\x00\x00\x00\x00\x49\x45\x4e\x44\xae\
\x42\x60\x82\
\x00\x00\x04\x69\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x03\xc7\x49\x44\x41\
\x54\x48\x89\xb5\x96\x5f\x6c\x53\x55\x1c\xc7\xbf\xe7\xf6\x76\x9d\
\xed\xd9\x9d\x80\x33\xd7\x0d\x84\x90\x90\xf4\x99\x64\x8b\xc1\xa0\
\xa9\x6f\xc6\x9a\x28\x8e\x64\x11\x75\x0c\xb5\x38\xb6\x61\x02\xc9\
\x96\xf6\x41\xd3\x17\x16\x96\xcc\x07\xb7\x48\xb6\x48\x88\xa2\x23\
\x5b\x97\x21\xa6\x46\xd1\x40\xb3\x39\x20\x83\x2c\x04\x42\x5c\xe3\
\xb6\x6e\xbd\xdd\x9f\xeb\x03\x68\xdb\x75\xed\xbd\xf7\xdc\x73\x7c\
\x81\xe8\x1c\x93\xf6\x61\xbf\xe4\xf7\x76\x7e\xdf\xcf\xf9\x9d\xdf\
\xef\x77\xce\x21\x42\x08\x6c\xa6\x49\x9b\xaa\x0e\x40\x2e\x76\x61\
\x24\x12\x51\xb9\x28\x84\xb8\x10\x07\xb8\x2d\xbe\x33\xc1\x3f\x6b\
\x7a\xbb\x29\xf1\xc4\x40\x21\x44\x51\xfe\xed\x85\xaf\xcf\x24\x93\
\x73\x82\x73\x2e\x1e\x3c\xb8\x2f\xce\x7d\xf5\xe5\x72\xdf\xb9\x3e\
\xef\x93\xe2\x8a\x3e\x22\x5b\xd8\xaf\xd7\xd4\xec\x40\xa1\x90\x87\
\xa2\x54\xe2\xad\x37\x0f\xaa\xb0\xed\x58\x7f\x7f\xaf\xf7\xff\xe2\
\x8a\x07\x58\x6c\x74\x61\x41\x83\x10\x02\x2b\x2b\x19\xb8\xdd\x1e\
\x34\x1c\x3c\xa4\x5a\x36\x8f\xf5\xf6\x76\x6f\x08\x29\x1a\x60\x0a\
\xfe\xc9\x2f\x57\x2e\xeb\xcb\xfa\x12\x64\xd9\x89\x95\x95\x0c\x3c\
\x1e\x0f\xde\x39\xd4\xa8\x5a\x9c\xc4\xba\xbb\x3b\x1f\x0b\x29\x1a\
\x10\x68\x0c\xcc\x72\xc6\x7c\x97\x7f\xfe\x49\x5f\x5e\xfe\x07\x42\
\x3d\x14\x47\x1a\x8f\xa8\x82\x48\xb1\xce\xce\xf5\x90\x92\xda\x34\
\x10\x68\x8d\x73\x66\xfa\x7e\xf8\x31\xaa\x2f\x2e\x2d\xc2\xe1\x90\
\x91\x4e\xff\x09\x4a\x29\xde\x6f\xfa\x50\x85\x64\xc7\xc2\x9d\xe1\
\x35\x10\xf2\x68\xd0\x46\x46\x06\x76\x12\x49\xee\xb2\x18\xf3\x03\
\x24\xba\xca\x8c\x8e\xc3\x0d\x87\xe7\xcf\x0e\x9c\xdd\x29\x73\xa9\
\x8b\x31\xcb\x4f\x08\x89\x9a\xf9\x5c\x47\x2e\x97\x2f\x17\x44\x8a\
\xbd\xf6\xaa\x5f\xad\xae\xae\x46\xa1\x50\xc0\xb6\x6d\xcf\x20\x9d\
\xce\xa0\xf7\x8b\xcf\x75\x83\x5b\xbe\x53\x9f\x9e\x8a\xaf\xc9\x80\
\x13\xa9\x6b\xef\xde\xba\xfa\xfa\x03\x0d\xee\xba\xda\x17\xea\x65\
\x41\x4e\x03\x80\xcc\x44\xd7\xfe\x7d\xfb\xeb\x9b\xde\xfb\xc0\xfd\
\xd2\x8b\x2f\xd7\xc3\xe1\x3c\x7d\xf2\x64\x30\x6e\x19\xdc\x77\xe9\
\xfb\x8b\xba\x96\xd2\x20\x3b\x9d\xd0\xff\x58\x82\xa2\x54\xa0\xa5\
\xb9\x55\x95\x6c\x5c\x6d\x6f\x6f\xdf\xb3\x06\xc0\x4c\xcb\xbf\x63\
\xfb\xf3\x52\x3e\xbf\x8a\xad\x5b\xb6\x4a\xa6\x69\xfa\x01\xc0\xb0\
\x98\x7f\xd7\xae\xdd\x52\x3e\xbf\x8a\xaa\xaa\x67\x25\xcb\xb4\xfc\
\x00\x10\x0c\x06\xe3\x86\x65\x34\x5f\xbc\x34\x02\x57\x99\x0b\x65\
\x4e\x17\x16\x16\x35\xd0\x8a\x0a\xd4\xd5\xd6\x3e\xc7\x84\x75\x7e\
\x0d\xc0\x16\x3c\xfa\xdb\xd4\x3d\x9e\xcd\x66\x30\x71\xf3\x86\x0d\
\xce\xa3\x00\x20\x04\x8f\xde\xb9\x7b\x9b\x67\x32\x69\x8c\x8d\x8f\
\xda\x02\x22\x0a\x00\xe1\x70\xc8\x0b\x21\x9d\x69\xf9\xa8\x0d\xce\
\xb2\x32\x64\xb2\x69\x3c\x55\xee\xc6\x9d\xbb\xb7\x31\x36\x3e\xb6\
\x6c\x9b\xfc\x5d\xe0\x5f\x57\x45\x21\xc7\xda\x6f\x4d\xde\x04\x63\
\xcc\x4f\x08\x89\x32\x23\xdf\x01\x00\xcc\xc8\xb7\x5f\xbf\x7e\x0d\
\x16\x33\xfd\x00\x89\x16\x56\xad\x8e\x70\x38\xe4\xe5\x70\xc4\xda\
\x8e\xb5\xaa\x94\x52\xcc\xcf\xcf\x82\x52\x05\x73\xc9\x39\x0c\x47\
\x22\xba\x69\xd8\xaf\xf4\xf4\xf4\x4c\xaf\x29\x72\xb1\x16\x0a\x87\
\xbc\x4e\x21\xc5\xda\x5a\x3f\x56\x29\xa5\x48\xcc\xcd\x40\xa9\x50\
\xa0\xa5\x34\x0c\x0f\x47\x74\xcb\x34\x7c\x3d\x3d\x7d\xf1\x47\xeb\
\x4b\x6a\xd3\x50\x38\xe4\x75\x70\xc4\x5a\x5b\x8e\xab\x1e\x4a\x31\
\x3d\xf3\x3b\xa8\x87\x22\x99\x4c\x62\x70\x78\x68\x9d\x78\x49\x19\
\x04\x83\xc1\xdd\x0e\xa7\xb8\x76\xbc\xed\x84\x4a\x29\xc5\xf4\xcc\
\x14\x2a\x95\xa7\x91\x4a\xa5\x10\x19\x8e\xe8\x86\xcd\x7c\x7d\xff\
\x11\x2f\x29\x03\x9b\x58\x27\x8e\x06\x8e\xa9\xd4\xe3\xc1\x54\xfc\
\x1e\x2a\xa8\x02\x4d\xd3\x30\x18\x19\xda\x50\xbc\x34\x80\xc5\xde\
\xa8\xa9\xde\x8e\xc4\xfc\x2c\x2a\x95\x4a\x68\x5a\x0a\x83\x43\x83\
\xba\x55\xb0\x37\x14\x2f\x0a\x40\x08\x91\x09\x21\x55\x99\x6c\xf6\
\xca\xd8\xaf\xa3\x70\x95\xb9\x30\x33\x3b\x8b\x0b\x83\x03\xf7\x27\
\x6e\x4c\x34\xf7\xf7\xf7\x5b\x84\x90\x2a\x42\xc8\x63\x1f\xaf\x62\
\x5e\x34\x0a\xc0\x33\x16\x1b\x3f\x9f\xcb\xe6\xb6\xb8\xa9\x7b\x5f\
\x26\x9d\x89\x4f\xde\x9a\xfc\x26\x91\x98\x4f\x03\x50\x00\xd8\x00\
\x2c\x00\x7f\xad\xdb\x60\x31\x45\x26\x84\x10\x00\x2e\x00\xe5\x0f\
\x5d\x06\xc0\x00\x14\x1e\xba\x21\x36\x10\x2a\x79\x0e\x4a\xb5\x4d\
\xff\x55\xfc\x0d\x9c\xa5\x15\xfb\x30\x11\x6c\xa7\x00\x00\x00\x00\
\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x05\x5d\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x04\xbb\x49\x44\x41\
\x54\x48\x89\xb5\x94\x5b\x6c\x54\x55\x14\x86\xff\x3d\xe7\x9c\x39\
\xd3\xe9\x74\x9c\xb6\x20\x1d\x0a\x2d\x85\x8a\xbd\x10\x02\x96\x34\
\x03\x4d\x03\x0f\x46\xd1\x56\x0c\xc1\x62\x79\x30\xf1\x4d\x49\x94\
\x17\x13\x91\x08\x21\x23\x11\xa1\x18\x95\x34\x0a\x11\x02\x89\xd1\
\x44\x28\x0a\x18\x2a\xd7\x16\x2b\xd6\x16\xb0\x46\x05\x94\xd0\x40\
\xe9\x74\x98\x92\xd0\x76\x6e\x9d\x99\x73\xd9\x67\x2f\x1f\x5a\x86\
\xd2\x52\xf0\x41\x56\xb2\x5e\x76\xd6\xfa\xbf\xec\xf5\xef\xbd\x18\
\x11\xe1\x71\x86\xed\xb1\xaa\x03\x90\x1f\x55\x70\xfa\xec\x89\x15\
\x24\x68\x15\x18\xcd\x21\x41\x33\x88\x28\x9b\x48\xdc\x20\xe0\x38\
\xb3\xd0\x3c\x3c\xac\x77\x2a\x0a\x16\x08\xd0\x2e\x01\xc4\xc1\xc4\
\xa6\x57\x5e\xae\xff\xf5\x91\x80\x93\x2d\xcd\xd5\x8c\xa8\x21\xdf\
\x3b\xd3\x37\x6b\xd6\x1c\xa8\xaa\x03\xb2\x3c\x52\x6e\x9a\xe6\x82\
\x68\x34\xb2\xa0\x37\xd0\xb3\x41\x37\x03\xdd\x26\x37\xd4\x17\x9f\
\x5f\x51\x30\x38\x34\x88\xf6\xce\x73\x0e\x00\x55\x69\x21\x22\x9a\
\x90\xcd\x27\x8f\x6e\xe9\xb8\xf0\x0b\x69\x9a\x46\x42\x08\xd2\xb4\
\x14\xc5\xe3\x31\x0a\x87\x07\x29\x1c\x1e\xa4\xe1\xe1\x38\x19\x86\
\x4e\x96\x65\x91\xae\xeb\x74\xea\xcc\x71\x22\x22\x1a\x1a\x1a\xa0\
\xaf\xbe\xd9\x4f\x63\xb5\x26\xdc\xe0\xd8\x8f\x3f\xbc\x59\x58\x50\
\xb8\x71\x5e\xf9\x7c\x18\x86\x8e\x48\x24\x0c\x59\x96\x60\xb3\x49\
\xb0\xdb\x55\x30\xc6\x20\x84\x40\x2a\x95\x82\x10\x16\x32\x32\x9c\
\x58\xe2\xab\x4e\xf7\x73\x6e\x4e\xee\xc1\x91\x63\x87\x96\xe5\x78\
\x72\x1b\xe7\x95\xcf\x47\x2a\x95\x84\x69\x9a\x50\x55\x15\x91\x68\
\x18\x37\x7b\x6f\x22\x91\x88\x43\xd3\x74\x4c\x7b\x72\x1a\xbc\xde\
\x7c\xe4\xe6\xe4\x42\xd3\x34\x08\x61\xc1\xe1\x70\x8c\x00\x4c\xfe\
\x60\x40\x53\x53\x93\x64\x53\x68\xaf\xaf\xb2\x4a\x36\x0c\x03\xa6\
\x69\x40\x96\x65\x5c\xec\x3a\x8f\x50\xff\xad\x3f\x01\xb1\xc5\x62\
\xd6\x65\xae\x89\xf2\x3b\x83\x77\xb6\x5f\xba\x72\xa9\x78\x56\xe1\
\x6c\x54\x2c\x7c\x06\x00\x10\x8b\x45\x46\xfc\xe1\x93\x00\x48\x32\
\x7c\xf9\xde\xa2\x39\xb2\x2c\x23\x16\x8b\xc0\x6e\x57\xf1\xc7\x5f\
\xbf\x23\x10\x0c\xec\x79\x6d\xcd\xeb\x6f\x00\x20\x00\xd8\xb3\x6f\
\xf7\x17\x75\xab\xea\x8b\x3d\x4f\x78\x00\x00\x96\x65\xa5\xc5\x85\
\x10\xe0\x93\x01\x2c\x43\xd4\x14\x15\xcd\x86\x65\x71\xd8\x6c\x12\
\x06\x06\x07\xd0\xdd\xdd\x7d\xc1\xe9\xc8\x7a\xeb\xae\xf8\xe8\x8c\
\xb3\x12\xc3\xc3\x20\x61\xa5\x8d\x14\x24\x40\x82\x40\x24\xc0\xcd\
\x49\x3c\x30\x2d\xfe\x42\x4e\x76\x0e\x0c\xc3\x80\x24\x49\xe8\x0b\
\x06\x60\x72\x73\x77\x5d\x5d\x9d\x31\xb6\xc1\xb4\x8c\xb5\x87\x0e\
\x1f\xfc\x9a\x88\x4a\x88\x68\x54\x78\x0c\x68\xdc\x66\x48\x03\x38\
\xe7\xb3\x65\x59\x41\x32\x99\x80\xdd\xae\x22\xd0\x17\x80\x2e\x78\
\x2b\xc6\xc5\xba\xb5\xef\x74\x01\x28\x1d\x7f\x3e\x59\xa4\x57\x05\
\xe7\x3c\xcc\x39\x07\x63\x36\x10\x11\x14\x59\x06\x04\xd4\xff\x2a\
\x34\x59\xdc\xf3\x80\xf3\xa0\x6e\xe8\x85\x92\x34\x02\x70\x65\xba\
\x10\x0c\x05\xcb\x00\x5c\x7b\x98\x80\xff\x33\xbf\x47\xd1\xd9\x56\
\x12\xa8\x25\xa2\x2e\x8b\x61\xfd\xe6\x0d\x9b\xd3\x3d\xf7\x46\x64\
\x5a\xd7\xe3\xf1\x58\x95\x3b\xcb\x0d\xce\x4d\x94\x97\xcf\xc7\x95\
\x7f\xfe\xde\x08\xe0\x28\xc6\x98\x7c\x9f\xb8\xdf\x6f\xb7\x29\x38\
\xb6\x72\xe5\xaa\xaa\x92\x92\x32\x04\xfa\x7a\x67\xee\xdb\xbf\x37\
\x13\xc0\x73\x77\x6b\xd2\x23\x32\x2d\xe3\xbb\xf6\x8e\x76\x48\x92\
\x0c\x4d\x4b\x61\xea\x94\xa9\x28\x2d\x2d\xab\xd8\xd6\xf0\xe1\x97\
\x7e\xbf\xdf\x3e\x51\x9e\x31\xb2\x99\x9f\x2f\xad\x5e\x5a\x35\x77\
\x6e\x09\x7a\x7a\xaf\xc3\xe1\x70\x40\x51\x94\x65\x7e\xbf\xdf\x99\
\xae\x1a\xeb\xfa\xf6\x1d\x5b\x3b\x5e\xad\xab\xf7\xb9\xdd\x6e\x08\
\x12\xc8\xc9\xce\x45\xc7\xf9\x0e\xb4\xb4\x9e\xb9\x00\xa2\xdd\x06\
\xb3\x5a\x15\x2e\x54\x0e\x94\x01\xd8\xe8\x5b\xe4\xab\x58\xbe\xbc\
\x06\x81\xbe\x1e\x10\x80\x58\x34\x86\x03\x07\xbe\x6d\xfb\x68\x6b\
\xc3\xb2\x09\x23\x02\x00\xc1\xad\x77\x4f\x9d\x3e\xf1\xf3\xea\xba\
\x7a\x24\x93\x29\xf4\xdf\x0e\xc1\x57\xb9\x18\xa5\x4f\x97\x55\x5e\
\xbd\x76\xb5\xf2\xb7\xae\x8b\xf0\x78\x3c\x98\xee\xf5\xa2\x62\xe1\
\x22\xb8\xdd\x6e\xdc\xea\x0f\x42\xd3\x34\x28\x8a\x1d\x87\x8f\x7c\
\xcf\x0d\x4b\xf7\xdf\x77\xcf\xf1\xef\xd6\xff\xc1\xa6\x6d\x79\xde\
\xe9\xeb\x6b\x6b\x6a\x47\x96\x9a\x96\x44\xb6\x27\x17\x59\xae\x2c\
\xa8\xaa\x0a\xcb\x1a\xf9\xad\xf1\x78\x14\xc1\x50\x1f\x9c\x19\x4e\
\xd8\xed\x2a\x9a\x9a\x0e\xe2\x56\x28\xb4\x6e\xe7\xa7\x8d\x8d\x0f\
\x05\x00\xc0\xfb\x9b\xde\x7b\x3b\xd3\xe9\xfc\xa4\xf6\xa5\x15\x72\
\x6e\xce\x14\xe8\x5a\x0a\x29\x2d\x05\xc3\x34\xc0\x18\x83\xcd\x66\
\x83\x2c\xc9\xc8\xcc\x74\x21\x10\x08\xa0\xf5\x6c\x0b\x06\x06\xee\
\x34\x34\xee\xdc\xb5\x7e\x82\x53\xe3\x01\x8c\x31\x07\x00\xe7\x9a\
\x35\xab\x9f\xcd\xcb\xcf\xdb\x51\x50\x50\x58\xf0\x54\x71\x31\x66\
\xce\x28\x80\xdb\xed\x86\xae\x69\x48\x24\x13\x88\x44\xa3\xe8\x3c\
\xdf\x89\x9e\x1b\x3d\x97\x7b\x6e\xde\xf8\xb8\xe5\xd4\x4f\xed\x00\
\x34\x00\x49\x00\x49\x22\xd2\x26\x00\x18\x63\x12\x80\xcc\xd1\x74\
\x2a\x8a\xe2\xaa\xae\x5e\x52\x39\x6d\x7a\xde\xd2\x2c\x97\x6b\xb1\
\x24\xcb\x5e\x6e\xf2\x84\xa1\x1b\x43\xba\xae\xf5\xf7\x87\x6e\xb7\
\xb5\xb5\x9d\x3b\x0b\x20\x75\x57\x78\x34\x13\x00\x12\x44\x64\x3d\
\x70\x44\x8c\x31\x05\x80\x03\x40\x06\x00\x15\x80\x1d\x80\x02\x40\
\xc2\xbd\xa7\x2d\x00\x58\x00\x4c\x00\x06\x00\x7d\x14\xa4\x11\x51\
\x7a\xe3\x3d\x10\xf0\x7f\xc6\xbf\x6c\x7a\x91\x48\x35\x1c\x9c\x0c\
\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x04\xac\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x04\x0a\x49\x44\x41\
\x54\x48\x89\xb5\x94\x5b\x6c\x54\x55\x14\x86\xff\x7d\x66\x18\x3b\
\x33\xbd\xd8\x6a\xec\x99\xa2\x68\x62\x4c\x4e\x78\x40\x63\x4c\x34\
\x18\x53\x6a\xe9\x25\x58\x48\x19\x9a\x56\x8a\xa5\x84\x27\x91\x18\
\x9f\xb0\x49\x09\x36\x35\x71\x9a\x36\x96\x17\x27\x51\xe7\xc1\x4c\
\x50\x43\x14\x2d\x9d\x5e\x00\x35\x3a\x9a\x40\x7c\xa1\x86\x18\x03\
\x55\xb0\x55\x3a\x6d\x27\x85\x5e\x98\x9e\x99\x76\xce\xd9\x7b\x2d\
\x1f\x3a\xa5\x25\xb4\x58\x50\x56\xb2\xb3\xff\xac\xb5\xf7\xff\x65\
\xaf\xac\x73\x04\x33\xe3\x7e\x86\x73\x2d\x87\xce\xfc\x78\xe6\x09\
\x07\xa1\x5d\x4a\x59\x25\x04\xf7\xcd\x2b\xd5\x54\x5d\x59\xfd\xd7\
\xff\x06\x10\x92\xda\x37\x6e\xdc\x54\xe3\xd3\x8b\xb4\xb1\xf1\xd1\
\x9a\x5f\x2e\x9c\x07\x80\xba\xbb\x02\x9c\x3a\x75\x42\xb7\x95\x68\
\x26\x66\x3f\x31\x77\x0b\x25\x8f\xfa\xfd\xf5\x43\x00\x20\x6d\xbb\
\xca\xa7\x17\x69\xc9\xe4\x2c\x5c\xae\x75\x9a\x6d\x59\x55\x8b\xf7\
\x42\xa1\x0f\x9e\xb4\x89\xdf\x65\xa2\x62\x45\xaa\xd7\xd2\xa8\xf5\
\xd0\x1b\x87\xe2\x8b\x75\x6d\x51\xd8\x52\xb4\x3c\xf7\xec\xf3\x6f\
\xee\x78\xc5\xbf\xbe\xb4\xb8\xec\xa0\x24\x71\xee\xf8\xf1\xb0\x01\
\x00\xc4\xd4\xf7\xeb\x6f\x17\xe8\x46\xe2\x06\xfe\xb8\xfc\xbb\x62\
\x50\x1f\x00\x04\x43\x41\x43\x12\xce\xee\xae\xdd\x53\x7f\xf0\xc0\
\x5b\xeb\x77\xee\xa8\x79\x5d\x9b\xa7\xe6\xe5\x2f\x58\x02\x28\xb9\
\xbd\xa8\xe8\x51\x58\x56\x1a\x39\x39\xb9\xd8\x56\x59\xa5\x4b\x20\
\x1a\x0e\x87\x8c\xa4\x95\x6e\x1a\x1e\xba\xf2\xd5\xb9\x9f\xcf\xa6\
\x62\x63\x63\x5f\x9b\xe9\x74\x53\x30\x14\x34\xa0\x28\xfa\x5a\xfd\
\x5e\x3d\x2f\x2f\x0f\xa6\x99\x40\x7e\x7e\x3e\x6c\x25\xfd\x2b\x02\
\x14\xa9\x9f\xa6\xa6\x26\xc1\x0c\x98\x66\x02\x6e\xb7\x07\xd5\xdb\
\x77\xe9\x2c\xb4\x68\x62\x22\x91\xb5\xb3\xba\xb6\xae\xae\xa6\xde\
\xfb\x6a\xcd\xee\x3a\xf3\xfa\x64\x16\xdb\x2a\xba\x77\x4f\xa3\xee\
\xf5\x7a\x91\x48\x24\x20\x84\x86\x3f\x87\xae\x80\xa4\xea\x5e\x11\
\x00\x29\xdf\x39\xfd\x6d\x7f\x7c\x62\x22\x0e\xa7\x73\x1d\x4c\x33\
\x01\x8f\xdb\x83\x1a\x7f\xad\xce\x0e\x19\x0d\x86\x82\x06\x00\x04\
\x83\x9d\x06\x41\x8b\x36\x36\xec\xd3\x3d\x1e\x2f\x66\x66\xa6\xe1\
\x74\x3a\x70\x75\xe4\x2a\xfa\x4f\xf7\xc7\x6d\x8b\x8f\xde\x32\x20\
\xcb\xbf\x83\x70\x38\x64\xb0\xa6\x45\x8b\x5f\x2a\xd1\x0b\x1f\x29\
\x84\x94\x36\xb2\xb3\x73\x91\x4c\x25\x71\xec\xb3\x70\x5c\x2a\xfb\
\x80\x60\xf1\xe1\xbe\xc6\xfd\xba\xd7\x93\x8d\xe9\xe9\x49\xb8\x5c\
\x2e\xc4\x46\x63\x38\x19\xe9\x8a\x2b\x2b\x5d\xd2\xd2\x12\x18\x5c\
\x15\xb0\x30\x15\x21\x83\x1d\x32\xba\x75\x4b\x99\xae\xeb\x3a\x2c\
\xcb\x42\x4e\x4e\x1e\x92\x29\x13\xe1\x63\x9f\xa0\xb1\x61\x3f\xbc\
\x5e\x2f\x26\x27\xaf\xe1\x01\x57\x16\x62\xa3\x23\xe8\x8e\x9c\x8c\
\x93\xb4\x6e\x33\x5f\x11\xb0\x38\x1d\x50\x14\x2d\x2b\x2d\xd7\xf5\
\x42\x1d\xe9\xf4\x1c\x0a\x0a\x1e\x86\x10\x1a\x88\x08\x13\xd7\xe2\
\xc8\xca\x72\x23\x36\x12\x43\x77\x4f\x57\x3c\x4d\xb2\x24\xb0\x82\
\xf9\xaa\x00\x00\xe8\x0c\x76\x1a\x82\x38\x5a\xb1\xb5\x42\xf7\xe9\
\x3e\xa4\xe6\x52\xc8\x7f\xb0\x00\x93\x53\xd7\xe1\x76\x7b\x10\x1b\
\x1d\x41\x24\x12\x89\x5b\xbc\xba\xf9\x1d\x01\x00\xd0\xd6\xd9\x66\
\x38\x20\xa2\x95\x65\x15\xba\xcf\x57\x84\x59\x73\x16\x5e\x6f\x36\
\x62\xb1\x11\x44\x7a\x22\x71\x69\x51\x49\x20\xb0\xba\xf9\xbf\x02\
\x00\xa0\xad\xad\xd5\x20\x21\xa2\x95\xe5\xdb\xf4\xc7\x37\x6c\xc0\
\xf0\xdf\xc3\xe8\xed\x89\xc4\xa5\x6d\x95\x04\x02\xef\xdf\xd1\x7c\
\x4d\x00\x00\x68\x6d\x6d\x36\x48\xd3\x7e\x78\x7a\xd3\x33\xbe\x81\
\x81\x81\x71\x96\xf6\xcb\x6b\x31\x5f\x33\x00\x00\x8e\x1c\x79\xfb\
\x29\x5b\xf1\xa7\x24\x45\x43\x47\x47\xc7\xe5\x35\x5d\xba\x1b\xc0\
\xbd\xc6\xcd\xbf\x69\x57\xd7\x97\x2f\xc2\x21\x3a\x88\xd4\x66\xa5\
\x08\x44\x0a\xa4\x08\x8a\x16\xf4\x42\x8e\x40\x4a\x65\x72\xcb\xb4\
\x22\x28\x52\x20\xa2\x41\x65\xc9\x86\xc3\x87\x5b\xce\xdf\x02\x10\
\x42\x38\xbf\x38\xf1\xf9\x7b\xa5\x5b\xca\x37\xe7\xe5\xe6\x61\xe9\
\x51\x0c\x5e\xd8\xd6\xa0\x19\x97\x06\x2f\x1a\x91\xde\xc8\x47\x42\
\x88\x17\x98\x59\x02\x80\x53\x08\x21\x00\xb8\x93\x73\x73\x0f\xcd\
\xcc\x4c\x23\x3d\x3f\x07\x62\x06\x11\x81\x99\x40\xc4\x99\x9d\x32\
\xb9\x85\x1a\x31\x81\x89\x41\x4c\x37\xcf\x8e\x8d\x8f\x21\x95\x9a\
\x93\x00\xdc\x42\x08\x93\x99\xd9\x09\x40\x00\x70\x7c\xf7\xcd\xf7\
\xed\xe9\x74\x3a\xe0\x72\x3a\x1f\xbb\xad\x05\x2b\xb7\x63\x49\x67\
\xda\x37\x6b\x9a\x17\x07\x07\x2f\x7d\x0c\xc0\x91\xf1\x65\x91\x11\
\x2e\x00\xb9\x00\x3c\x99\xe2\xbd\x86\x02\x90\x02\x90\x00\x60\x31\
\x33\x0b\x66\x46\xa6\x4d\x5a\x66\x89\xff\x00\x60\x00\x04\x80\x38\
\x33\x9e\xf7\x7d\x4c\xff\x01\xfb\x18\x7f\x53\x4a\x38\xba\x52\x00\
\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x5a\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x03\x00\x00\x00\xd7\xa9\xcd\xca\
\x00\x00\x00\x03\x73\x42\x49\x54\x08\x08\x08\xdb\xe1\x4f\xe0\x00\
\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\x01\
\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\x74\
\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\x70\
\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x0a\x74\x45\x58\
\x74\x54\x69\x74\x6c\x65\x00\x5a\x6f\x6f\x6d\xbc\x01\x55\x2b\x00\
\x00\x00\x26\x74\x45\x58\x74\x41\x75\x74\x68\x6f\x72\x00\x4a\x61\
\x6b\x75\x62\x20\x53\x74\x65\x69\x6e\x65\x72\x2c\x20\x4c\x61\x70\
\x6f\x20\x43\x61\x6c\x61\x6d\x61\x6e\x64\x72\x65\x69\x14\x54\xf1\
\xa7\x00\x00\x01\x35\x50\x4c\x54\x45\x78\x78\x78\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\xbf\xb3\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x3e\x36\x00\
\x00\x00\x39\x39\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x1a\
\x1a\x15\x15\x15\xbc\xbf\xb9\xbe\xc1\xbb\x70\x71\x6e\x4d\x4e\x4b\
\x4c\x4d\x4a\xbe\xc0\xbb\x68\x69\x66\x77\x79\x74\xbd\xc0\xb8\xbd\
\xc0\xb9\x67\x68\x65\x5a\x5d\x58\xb9\xba\xb8\xba\xbc\xba\xe7\xe8\
\xe6\xe9\xea\xe8\xe9\xea\xe8\xb2\xb3\xb1\x55\x57\x53\x58\x5a\x56\
\x61\x63\x5e\x6c\x6e\x69\x77\x79\x74\x7a\x7d\x77\x7b\x7d\x78\x83\
\x85\x80\x8b\x8e\x88\x8e\x90\x8b\x94\x97\x91\x99\x9c\x96\x9b\x9e\
\x98\x9c\x9f\x99\x9d\x9f\x99\xa4\xa7\xa1\xa5\xa8\xa2\xae\xb1\xaa\
\xb0\xb3\xac\xb6\xb9\xb2\xba\xbd\xb6\xbc\xbf\xb8\xbe\xc1\xb9\xd9\
\xda\xd8\xdd\xde\xdc\xde\xde\xdc\xe2\xe2\xe0\xe3\xe3\xe1\xe6\xe7\
\xe5\xe8\xe8\xe6\xe8\xe8\xe8\xe9\xe9\xe8\xea\xea\xe9\xeb\xec\xeb\
\xed\xed\xeb\xee\xee\xee\xef\xef\xef\xf0\xf0\xef\xf2\xf2\xf1\xf2\
\xf2\xf2\xf3\xf3\xf1\xf3\xf3\xf2\xf3\xf3\xf3\xf3\xf4\xf3\xf4\xf4\
\xf3\xf5\xf5\xf4\xf5\xf5\xf5\xf6\xf6\xf6\xf6\xf7\xf6\xf7\xf7\xf7\
\xf8\xf8\xf7\xf9\xf9\xf9\xfa\xfa\xf9\xfa\xfa\xfa\xfb\xfc\xfb\xfc\
\xfc\xfb\xfc\xfc\xfc\xfd\xfd\xfd\xfe\xfe\xfe\xff\xff\xff\x5f\xb8\
\x25\x86\x00\x00\x00\x2b\x74\x52\x4e\x53\x00\x01\x02\x03\x04\x05\
\x06\x07\x0a\x0b\x0d\x14\x15\x16\x18\x1d\x1f\x21\x24\x24\x25\x28\
\x29\x46\x56\xa8\xa8\xa9\xd4\xd6\xec\xee\xee\xee\xee\xf0\xf8\xfa\
\xfa\xfb\xfb\xfc\xfd\x9d\xb2\x16\xe7\x00\x00\x01\x18\x49\x44\x41\
\x54\x28\x53\xad\x8d\x3d\x4b\x03\x41\x14\x45\xcf\x9b\x99\xcd\x07\
\x89\x22\x8a\x76\xd1\x14\xf6\xa6\xd0\x42\x50\xfc\xf5\x62\x23\x88\
\x85\x36\x82\x98\xa4\x10\x44\x49\x48\x58\xb2\x64\x66\xde\xb3\xc8\
\xee\x76\x76\x9e\xf2\x1e\x0e\x17\xfe\x0d\x01\x18\xec\xf7\x4e\xdb\
\x65\x56\xad\xca\x5a\x0c\x8e\xfa\x37\xbe\x15\xe9\x7e\xf3\x53\x82\
\x07\x8e\xf7\x6e\x51\x6b\x70\xe3\x4f\x59\xd7\xe2\x2e\x25\x6d\xc9\
\x36\x9e\x2f\x20\x00\x23\xb7\x05\x78\x06\x2e\x00\x3a\xa3\xf7\x9d\
\x80\x0a\xf0\xee\x9a\x87\x98\x81\x21\xec\x84\xa1\x21\x92\x05\x64\
\x0b\x45\xc2\x6a\xa1\x64\xff\xe1\xf0\xe0\x67\xe8\x79\x46\x9b\xc2\
\x62\xf0\x97\x00\x57\xf0\xa8\xd1\xda\x42\xd5\xbb\x08\x05\x11\x9c\
\x57\x6d\x8a\x94\x34\x84\x57\x6c\xc2\x8b\x10\x82\xa6\xd4\x14\x49\
\xed\x0c\xe6\x10\x46\x60\x9a\xda\x0f\x95\x6f\x38\xf1\x5b\xbc\xfb\
\x02\xd1\xf6\xc3\x1c\x20\x7e\x8a\x17\x07\x58\x53\x2c\xd7\x9d\x04\
\x7e\x04\xe0\x20\xac\x97\x40\x40\x88\x6f\x93\x4a\x59\x00\x50\xe0\
\x7a\x4f\x51\x30\xc1\x15\xc3\x83\xee\xf8\x90\x1a\x5d\x4c\xcb\x55\
\x99\x54\x08\x9d\xa2\x5f\x74\x7b\x8d\xa0\xaa\xe2\x66\x1b\x73\x40\
\x13\xea\x37\x22\xf5\x6e\x39\xe7\x9c\x0d\x01\x11\x71\x42\x2b\x30\
\x35\x33\xfe\xe4\x17\x2a\x34\x95\x20\xb0\xe4\x0e\x49\x00\x00\x00\
\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x17\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x03\x00\x00\x00\xd7\xa9\xcd\xca\
\x00\x00\x00\x03\x73\x42\x49\x54\x08\x08\x08\xdb\xe1\x4f\xe0\x00\
\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\x01\
\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\x74\
\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\x70\
\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x0a\x74\x45\x58\
\x74\x54\x69\x74\x6c\x65\x00\x5a\x6f\x6f\x6d\xbc\x01\x55\x2b\x00\
\x00\x00\x26\x74\x45\x58\x74\x41\x75\x74\x68\x6f\x72\x00\x4a\x61\
\x6b\x75\x62\x20\x53\x74\x65\x69\x6e\x65\x72\x2c\x20\x4c\x61\x70\
\x6f\x20\x43\x61\x6c\x61\x6d\x61\x6e\x64\x72\x65\x69\x14\x54\xf1\
\xa7\x00\x00\x01\x17\x50\x4c\x54\x45\x78\x78\x78\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\xbf\xb3\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x3e\x36\x00\
\x00\x00\x39\x39\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x1a\
\x1a\x15\x15\x15\xbc\xbf\xb9\xbe\xc1\xbb\x70\x71\x6e\x4d\x4e\x4b\
\x4c\x4d\x4a\xbe\xc0\xbb\x68\x69\x66\x77\x79\x74\xbd\xc0\xb8\xbd\
\xc0\xb9\x67\x68\x65\x5a\x5d\x58\xb9\xba\xb8\xba\xbc\xba\xe7\xe8\
\xe6\xe9\xea\xe8\xe9\xea\xe8\xb2\xb3\xb1\x58\x5a\x56\x77\x79\x74\
\x7a\x7d\x77\x7b\x7d\x78\x83\x85\x80\x8b\x8e\x88\x8e\x90\x8b\x94\
\x97\x91\x9b\x9e\x98\x9c\x9f\x99\x9d\x9f\x99\xa5\xa8\xa2\xae\xb1\
\xaa\xb6\xb9\xb2\xba\xbd\xb6\xd9\xda\xd8\xdd\xde\xdc\xde\xde\xdc\
\xe2\xe2\xe0\xe3\xe3\xe1\xe6\xe7\xe5\xe8\xe8\xe6\xe8\xe8\xe8\xe9\
\xe9\xe8\xea\xea\xe9\xeb\xec\xeb\xed\xed\xeb\xee\xee\xee\xef\xef\
\xef\xf0\xf0\xef\xf2\xf2\xf1\xf2\xf2\xf2\xf3\xf3\xf1\xf3\xf3\xf2\
\xf3\xf4\xf3\xf4\xf4\xf3\xf5\xf5\xf4\xf5\xf5\xf5\xf6\xf6\xf6\xf6\
\xf7\xf6\xf7\xf7\xf7\xf9\xf9\xf9\xfa\xfa\xf9\xfa\xfa\xfa\xfb\xfc\
\xfb\xfc\xfc\xfb\xfc\xfc\xfc\xfd\xfd\xfd\xfe\xfe\xfe\xff\xff\xff\
\x45\x0a\x3b\x0d\x00\x00\x00\x2b\x74\x52\x4e\x53\x00\x01\x02\x03\
\x04\x05\x06\x07\x0a\x0b\x0d\x14\x15\x16\x18\x1d\x1f\x21\x24\x24\
\x25\x28\x29\x46\x56\xa8\xa8\xa9\xd4\xd6\xec\xee\xee\xee\xee\xf0\
\xf8\xfa\xfa\xfb\xfb\xfc\xfd\x9d\xb2\x16\xe7\x00\x00\x00\xf3\x49\
\x44\x41\x54\x28\x53\xad\x90\x31\x4b\x03\x41\x10\x46\xbf\x99\xd9\
\x98\xc8\xa9\x28\x22\x09\x5a\x58\x5a\x59\x18\xff\x7f\x6f\x67\x61\
\x63\x61\x27\x82\x01\x03\x92\xcb\x91\x5c\x76\x67\xc6\xc2\xdd\xbd\
\x6b\xec\x7c\xe5\x7b\xcc\xc7\xb2\xc0\xbf\x41\x00\xd0\x9c\xcd\x16\
\xd5\x7c\xee\x37\x5d\x0e\xcd\xe5\xf1\x52\x6a\x48\xcf\xbb\x75\x07\
\x08\x80\xab\xd3\x47\x98\x17\xf8\xe6\x8b\x5a\x20\x00\x98\x3d\x44\
\x1b\xad\xf3\xf2\x09\x00\x03\x98\x73\xd4\x11\x91\xe7\xf8\xbd\x00\
\x7a\x8c\x69\x90\x83\xc3\x42\xac\x7a\x92\xe0\x35\xa8\x7c\x70\xf6\
\x76\xab\x43\xf0\x18\xe4\x3e\x87\x17\x8b\x5e\x83\x99\x70\xd9\x62\
\x31\x2b\x41\x93\x89\xbc\xe5\x20\x62\x49\x73\x30\x35\xbf\x46\xc1\
\x4d\xad\x4e\xd1\x1a\x03\x54\xa7\xcc\xcb\x93\xca\x4d\x0e\xed\xf6\
\x28\x8d\x7c\xd8\xb6\x00\x02\x08\xf1\xfd\xae\x1f\x3e\x8b\xa7\xaf\
\x91\xe0\x04\x9e\x9c\x9c\x4f\x17\x17\xc5\xdb\xf7\xaa\xdb\x74\xc9\
\x02\x58\x52\x77\x38\xac\xea\x45\xbf\x8f\xca\x84\x00\x4b\x30\xd9\
\x11\x65\xef\xaa\xaa\xea\x20\x80\x88\x98\x50\x03\xdc\xdc\x1d\x7f\
\xf2\x03\xb0\x32\x86\xc0\x2e\xb7\x38\x02\x00\x00\x00\x00\x49\x45\
\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x7d\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\xdb\x49\x44\x41\
\x54\x48\x89\xdd\x95\x4d\x68\x13\x41\x14\xc7\xff\xb3\xdd\xd9\xee\
\x66\x93\x46\xdb\x74\xad\x92\x6e\x88\x89\x16\xa1\x45\xc4\x2f\x0c\
\xc5\x93\x9f\x2d\x08\x22\xa8\x07\x2f\x5e\xed\x41\x0a\x0a\x52\x90\
\x14\x0f\x62\x4f\xb9\x08\x1e\x14\x41\x91\x8a\x9f\x58\xa4\xd1\x8a\
\xd1\x56\xd1\x56\x25\x42\xb1\x68\xc5\x4a\xd2\x5a\xf4\xa0\x6d\x6c\
\x4c\x9a\xc9\x6e\xb2\xe3\xc1\x0f\xd0\x44\xd3\x16\x3d\xe8\x83\x77\
\x19\x86\xdf\x8f\xf7\x78\x6f\x86\x70\xce\xf1\x37\x43\xf8\xab\xf4\
\xff\x42\x20\xfe\x7c\x40\x08\x91\x00\xc8\x00\x4c\x00\x59\xce\xb9\
\xf5\x47\x05\x00\xe4\x5b\xb7\xbb\xfb\xb2\x86\xd1\x77\xa1\xf3\x4a\
\x07\x21\x24\xf1\x55\x34\xb7\x69\xe0\x9c\xff\x90\x0e\x87\xa3\xea\
\x56\x24\xcc\xc7\xdf\x8e\x19\x91\xde\x9e\xe4\xe5\xab\xe7\x5b\xfd\
\x7e\x7f\x35\x00\xf9\xe7\xbb\x33\xc9\x82\x0a\x3c\x1e\x8f\x0d\x00\
\x6a\xb4\x85\xd4\x55\x59\x4d\xc7\xc6\x47\x8f\x9d\x38\x79\xbc\x35\
\x1e\x8b\xb7\xd5\xd7\xd7\xdf\x4e\xa7\xd3\x1f\x63\xb1\x18\x9b\x73\
\x8b\x74\x5d\x57\xb2\xd9\x2c\xf2\x79\x0b\xc9\x4f\x53\xa8\x76\x69\
\xd2\xc2\x9a\x45\xb5\xf3\x2a\x9c\xa7\x8e\x76\x1c\x79\x36\x34\x34\
\xdc\xde\xd4\xd4\x34\x08\xe0\x7d\x38\x1c\xce\xce\x5a\xe0\xf3\xf9\
\x14\xc6\x18\x38\x38\x0c\xd3\x40\x7a\x3a\x85\x5c\x3e\x07\x8f\xc7\
\x5b\xbe\xd8\xbb\x64\xa5\x6a\x53\xaf\x7a\xbd\xb5\x3d\xaf\x46\x62\
\xa1\x96\x96\x96\x11\x4d\xd3\xde\x05\x83\xc1\xdc\x8c\x05\x6e\xb7\
\xfb\x8b\xc0\xb2\x60\x9a\x06\x0c\xd3\x80\x99\x33\x30\x91\xf8\x00\
\x45\x56\xc8\x9a\xd5\xeb\xa4\x54\x2a\xd5\xac\xc8\x0f\x37\x25\x6b\
\xdd\x67\x27\x27\x92\x67\x42\xa1\x50\x3c\x99\x4c\xbe\x0b\x06\x83\
\x05\x13\x57\xb0\x07\x7e\xbf\x5f\x61\x8c\xc1\xe2\xd6\x77\x78\x59\
\x99\x08\x2a\x52\x10\x42\x90\x4a\x7f\x82\x62\x93\x85\x2d\x9b\x9b\
\xcb\x03\x81\xc6\xbd\xd5\x0b\xe6\x87\xe7\x57\x39\xf7\x35\x34\x34\
\xac\x01\x40\x4a\x0a\x74\x5d\x57\x58\x86\xc1\xb2\xac\x1f\xe0\x94\
\x52\x50\x51\x02\xa5\x14\x04\x04\x96\x65\xc1\xeb\xf5\x89\x3b\xb6\
\xef\xaa\xc8\xe5\xcc\x36\x41\xc0\xfa\x68\x34\x5a\x55\xb2\x45\xba\
\xae\x2b\xbd\xf7\x18\x38\xb7\x8a\xc2\xa9\x48\x21\x49\x32\x04\x22\
\x60\x34\x1e\xcb\xdf\xed\x8b\x4c\xbb\x2a\x5d\xa7\x03\x81\xc6\x41\
\x4d\xd3\x26\x4a\x0a\x34\x4d\x93\x19\x63\x20\x44\x28\x80\x4b\x54\
\x42\xb9\x24\x63\x32\x91\xe0\xdd\xdd\x5d\xa6\x6a\xb7\x5f\xdf\xbd\
\x73\xcf\x35\x55\x55\x07\x01\x3c\x07\x50\xb0\x8c\xc5\x36\x59\xfc\
\x22\x20\xdf\xe1\x12\x95\x60\x53\x54\x30\xc6\xf8\x85\xae\xce\x7c\
\x26\xc3\x06\x9a\xb7\x6e\xbb\xe8\x76\xbb\x9f\x02\x78\x0a\x20\x53\
\x84\xf3\x4b\x01\x65\x8c\x41\x10\x04\x50\x51\x82\x5d\x75\x80\x73\
\xe0\xc6\xcd\x70\xee\xf5\xeb\x91\xd8\x86\x8d\x9b\xcf\xad\x58\xbe\
\xe2\x09\x80\x47\x00\x26\x7f\x05\x2e\x59\x01\x15\x29\xec\x6a\x05\
\xa2\xd1\x27\xb9\x3b\xbd\x91\xa9\xc0\xda\xc6\xce\x83\x07\x0e\x3d\
\x00\xd0\x0f\x60\xac\x14\xf8\xb7\x02\x41\x10\x30\xfc\xf2\x85\x75\
\xf9\xca\x25\xa3\xae\x6e\xd9\xb5\xc3\x6d\xed\x77\x28\xa5\x03\x00\
\x86\x50\xa4\xcf\xb3\x15\x98\x9a\xb6\xe0\x4d\x7f\xff\xc3\x57\xad\
\xfb\x0f\xdc\x70\x3a\x9d\x03\x00\x1e\x03\x30\x66\x03\xfe\x16\xa4\
\xc8\x2b\xbc\x14\xc0\x2a\x00\x53\x00\xee\x03\x48\xce\x05\xfc\x3b\
\xc1\x1f\x8d\x7f\xff\x4f\xfe\x0c\xd4\xda\x57\xdf\x81\x0c\x47\x3c\
\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x04\x17\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x0e\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x46\x6f\x6c\x64\x65\x72\x73\x21\
\x54\xaa\x60\x41\x00\x00\x00\x17\x74\x45\x58\x74\x41\x75\x74\x68\
\x6f\x72\x00\x4c\x61\x70\x6f\x20\x43\x61\x6c\x61\x6d\x61\x6e\x64\
\x72\x65\x69\xdf\x91\x1a\x2a\x00\x00\x00\x29\x74\x45\x58\x74\x44\
\x65\x73\x63\x72\x69\x70\x74\x69\x6f\x6e\x00\x42\x61\x73\x65\x64\
\x20\x6f\x66\x20\x4a\x61\x6b\x75\x62\x20\x53\x74\x65\x69\x6e\x65\
\x72\x20\x64\x65\x73\x69\x67\x6e\xa0\x84\x05\x73\x00\x00\x03\x22\
\x49\x44\x41\x54\x48\x89\xed\x94\x4b\x68\x5c\x55\x18\xc7\x7f\xe7\
\xcc\x9d\x8c\xa9\xe9\x23\x26\x4d\xc0\xda\xc6\x06\xaa\x2d\xa8\xd0\
\xa2\x09\x82\x16\x2c\x08\x06\x57\xae\x14\xac\x1b\x1f\x28\x88\xbb\
\xa2\x0b\xf1\x01\x6d\x17\x2e\xdc\xb8\x55\x44\x90\x6a\x21\x3b\x51\
\xaa\x5d\x4a\x11\x8c\x8f\xc4\x44\x83\xa1\xd6\x74\x4a\xcd\xf4\x95\
\xa4\x99\x99\x3b\x33\xf7\x9e\x7b\xbe\xcf\x45\x6e\xe6\x61\x26\xd3\
\x5a\xb7\xfe\xe1\xc2\xfd\xee\x77\xce\xff\xc1\xb9\xe7\x83\xff\x71\
\x03\x98\xe6\xe2\xd8\x0b\x07\x5e\xc7\x70\xd4\x18\xd3\x05\x80\x6a\
\x53\x57\xcb\x89\xe8\x2b\xef\x7c\x3c\x75\xe2\x96\x05\x8e\xbf\x74\
\xa0\x32\xfa\xc4\xf3\xdd\xd6\x66\x50\x11\x44\x3c\x22\x1e\x15\x21\
\xae\x55\x98\x9d\xf8\x32\x8c\xab\x95\x87\xdf\xfe\x64\x66\xe6\x66\
\x05\x82\xe6\x42\xd5\x64\x51\x25\x3f\xf7\xf3\xba\x85\x3d\x5b\xfb\
\x18\xba\x77\x74\xd3\xb9\x5f\xcf\x4c\x1f\x7b\x71\x7f\xd3\xa6\x16\
\xbb\x55\x03\x6f\xbd\xf9\xd1\xe4\xfb\x6d\x05\x44\xa1\x56\x29\xb5\
\x75\x52\x5e\x59\xe2\xf6\xcd\xdb\xcc\xbe\x87\xc6\x50\x55\x54\x04\
\x55\xa9\x27\x14\x11\x92\xb8\xd6\x9d\x9f\xfb\xfe\x38\xb0\x81\x80\
\x78\xc2\xf2\x0a\x5e\x04\x80\xf9\x6b\x9e\xf9\xcb\x55\x5c\x92\xa4\
\x2b\x16\xdb\x8a\x67\x83\x80\xdd\x83\xdd\xec\xee\x0f\xf0\x5e\x72\
\xcd\xbd\x16\x01\xef\x85\x95\xeb\x8b\x24\xb1\x03\xe0\xdc\xa5\x2a\
\x27\x3e\x3d\x89\xb5\xb6\x2d\x71\xc3\x98\xf0\xec\x73\xcf\xb0\x63\
\x4b\x37\xd2\xf2\x63\xac\x4b\x00\x61\xb9\x8c\x31\xb6\x2e\x68\xad\
\x65\x79\xb9\xbd\xf3\x35\xf4\xf6\xf6\xe1\xbd\x10\xbb\x84\x34\xfc\
\x46\x02\x8a\x8b\x1d\x98\x56\xc7\x3f\x4e\x4e\x74\x14\x78\xfc\xd0\
\x18\x00\x71\xec\x10\xe9\x90\xc0\x2b\x44\xae\x59\x20\x03\xc0\x83\
\xfb\x47\x3a\x0a\xac\x21\x72\x0e\xdf\xca\xbf\x3e\x41\xec\x3c\xb0\
\x96\x33\xf3\x2f\x13\x24\x9d\x13\x88\x28\x71\xec\x68\xdc\xbf\x1c\
\x95\x4a\x85\xa1\xbb\x86\x11\xf1\x1b\x0a\x14\x0a\x05\x6a\xb5\xda\
\xaa\xc0\x8d\x0e\x39\x76\x0d\x81\x5a\xb5\xc6\xb5\x2b\x0b\xfc\x39\
\xf9\x35\x95\xa5\x05\xc4\x27\xb4\x83\xb1\x96\xa7\x46\xef\x24\xb0\
\x8a\xea\x0e\x3e\x1f\x39\x58\x10\xf5\x56\xbc\xfb\xc3\x7c\xf0\xda\
\x58\x2e\xd7\xbb\xe5\xc3\xa0\x2b\x37\x22\xe2\xef\x11\x32\xf5\xf1\
\xe1\xc5\xb2\x7d\xfb\x00\x03\x3b\xf7\x30\x38\x74\x1f\x49\x7a\x1f\
\x54\x15\xd0\xc6\x25\xd6\xd5\x6f\x9a\xba\x0f\xb2\x59\x0a\xf3\xbf\
\x31\xf7\xd3\x37\xf9\x20\x72\x7e\xab\x0b\x2b\x87\x0f\x3e\xf6\xb4\
\xd9\xbc\xad\x0f\x55\x41\x95\xfa\x62\x00\x9f\x38\x96\x2e\xe7\x71\
\x71\x84\xd2\x20\xfa\x27\xb1\xaa\x62\x6c\x86\xae\xdb\x36\x31\xfb\
\xc3\xe9\x24\x0a\x4b\xef\x1a\x80\xa3\x2f\x1f\x9a\x7e\xe4\xc9\xc3\
\xf7\xf7\xf5\x0f\x50\x5a\xbe\xda\xb2\xa1\xc1\x95\x12\xd5\x7b\x0d\
\x13\xab\xbd\x46\x9d\x3f\x3b\xcd\xc2\xf9\xdf\x2f\xcc\x2c\xf5\x0f\
\x5b\x80\xeb\xc5\xe2\xa9\xc9\xef\x4e\x3b\x17\x95\x51\x89\x50\x89\
\x11\x1f\x21\x3e\x42\x25\x6a\x7a\x8f\xd3\x5e\x5c\xaf\x45\xa2\x96\
\x3a\x8a\x4a\x9c\x9d\x9d\x4a\x56\x8a\xc5\xf7\xc6\xc7\xc7\x7d\x00\
\x98\x8b\x97\x16\x3f\x8b\xa2\xea\x91\x5d\xc3\xfb\xd8\x79\xf7\x1e\
\xb0\x16\x63\x4c\x7a\xd8\x06\x8c\xc1\x18\x8b\x69\x4a\x22\xe9\x80\
\x53\x11\x44\x25\x1d\x7e\xca\x2f\x67\x4e\x49\x29\x0c\x2f\x7e\x31\
\x71\xfe\x24\x60\x0c\x60\x81\x9e\x47\x1f\x18\x7c\x75\xef\xae\x3b\
\x8e\x04\x41\xa6\xf3\xe0\xe9\x04\x83\x29\x87\x71\xf9\xdb\xa9\xbf\
\xde\xc8\x5f\x09\xbf\x02\x8a\x6b\x36\xbb\x80\x7e\x60\x2f\xd0\x73\
\xcb\x02\xab\x08\x81\x39\xe0\x2a\x10\xad\xfd\x92\x06\xc8\xa6\x8f\
\xd9\x60\xe3\xcd\x42\x01\x07\x24\x80\x34\x93\xfd\x57\xe2\x76\x42\
\xfc\x0d\x57\x17\xef\xa6\x5f\x63\xe5\x3e\x00\x00\x00\x00\x49\x45\
\x4e\x44\xae\x42\x60\x82\
\x00\x00\x05\x56\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x04\xb4\x49\x44\x41\
\x54\x48\x89\xb5\x94\x6b\x6c\x54\x55\x10\xc7\xff\xf7\xee\xdd\x2d\
\x2c\xa5\x2d\x18\x2a\x92\x98\x34\x42\x61\x09\x51\xab\x22\x5a\x4a\
\x7c\x24\xf2\x30\x90\x10\x43\x6a\x04\x0c\x21\x91\x40\x48\x5a\xac\
\x22\x89\x62\x82\x09\xe8\x42\x4b\x45\x43\x0c\x2a\xd6\xb4\x94\x36\
\xd4\x3e\x20\x6c\xa4\x52\x10\xa9\x44\x05\x42\x24\xd0\x42\x79\x2c\
\xf4\x61\x69\x4b\xbb\xdd\x6e\x77\xbb\xbb\xbd\xf7\x9e\xb9\x77\xfc\
\xb0\x0f\xbb\xa6\x40\x31\x71\x4e\xce\x97\x73\x66\xe6\x37\x8f\x73\
\x46\x62\x66\xfc\x9f\xa2\x8c\x55\xb1\xb1\xb1\x26\x39\xac\x26\x7d\
\x10\x1a\xa7\x15\xe7\xbe\x92\x1b\x1c\xab\x9d\x3c\x16\x25\x97\xcb\
\x35\x2d\x10\xb4\x9c\x79\x6c\xea\xb4\x4f\x6c\x41\xf9\x8c\xcb\x55\
\x35\x6d\xac\x00\xe9\x41\x25\x72\xb9\xea\x9e\x32\x60\xfe\xf8\xea\
\x4b\xaf\x3d\x9e\x96\x36\x09\x83\x83\x3e\x9c\xfc\xa5\xa1\x53\x66\
\x5e\xb6\x62\xc5\xca\xa6\x07\x12\x98\xf9\x9e\xbb\xb6\xb6\x72\xf1\
\x11\x57\x5d\x20\x1c\x0e\x31\x11\xb1\xdf\xef\x63\x22\xe2\x70\x38\
\xc4\x75\x87\xab\x03\x95\x95\xe5\x8b\xef\x67\xcf\xcc\xf7\x06\x54\
\x55\x57\xae\xaf\x6f\x70\x09\x5d\xd7\x59\x08\x9d\x7d\x3e\x2f\x07\
\x02\x7e\xf6\xf9\xbc\x2c\x84\xce\xba\xae\xf3\x51\xd7\x11\x51\x76\
\xf0\xbb\xf5\x0f\x0b\x90\x2a\xaa\xca\x0a\x4f\xff\x7a\x92\x0d\x83\
\x58\x55\x55\xf6\xf9\xbc\x1c\x0a\x05\xb9\xcf\xd3\xcb\xa1\x50\x90\
\x7d\x3e\x2f\xab\xea\x30\x13\x11\x1f\x3f\x71\x8c\xf7\x97\x7c\x5d\
\xc8\xcc\xd2\x68\x80\x84\x1e\x94\x95\x95\x8d\x93\xad\x5c\x3e\xdb\
\x31\x27\x77\xee\xb3\xcf\x43\x55\x87\xa1\xeb\x1a\xac\x56\x1b\xae\
\xdf\x68\xc1\xc5\x4b\x17\x29\xeb\xe9\x67\x14\xc7\xac\xd9\x50\xd5\
\x61\x24\x25\x8d\xc7\x04\xfb\x04\x9c\x3d\xff\x1b\x2e\x37\x5d\xae\
\xb1\x27\x4d\x5c\xb3\x76\xed\x5a\x75\xd4\x26\x97\x96\x96\x4e\x61\
\xd9\x38\x9a\x93\x9d\x93\x3d\x33\xd3\x81\x70\x38\x08\x22\x03\x8a\
\x62\xc1\xf9\x0b\xe7\xe1\x76\x5f\x3f\x61\x91\xf8\x1d\x61\x4a\xdf\
\xcf\x98\x9e\xb9\x68\xde\xdc\x79\xd0\x34\x15\x8a\x62\x45\x5a\xda\
\x64\x5c\x69\x69\xc2\xe9\xc6\x53\x67\x65\xb6\x2d\xcf\xcf\xcf\xf7\
\xc4\x00\x72\x24\xf2\x7d\x53\x05\x6b\xe7\x96\x2c\x7a\x3d\x7b\x66\
\xe6\x2c\x0c\x0d\x05\x60\x9a\x26\x24\x09\x38\x79\xea\x04\xae\x5d\
\x6f\x29\xb9\xdb\xed\x5d\xba\x6e\x5d\xfe\x9d\xbe\x1e\xef\xd2\x6b\
\x2d\x57\x4b\x1a\x7e\x6e\x80\x24\xcb\xd0\x74\x0d\xbd\x7d\xdd\x98\
\x33\xfb\x49\x2c\x5f\xf6\x46\xb6\x2a\xc2\xe7\x8a\x8a\x8a\xfe\x79\
\xc6\xcc\x8c\x7d\xdf\xee\xfd\xa2\xb7\xf7\x2e\x1b\x06\xf1\xe0\xe0\
\x00\x0f\x0d\xf9\xd9\xd3\xdf\xc7\xe5\x15\xa5\xe6\x97\x7b\x8b\xb7\
\x8e\x56\xdb\xe2\x3d\x45\x5b\xf7\x97\x7c\x63\xfe\xd5\xd9\xce\x5d\
\xdd\x9d\xdc\xda\x76\x8b\x75\x5d\xe3\xa6\xe6\x4b\xec\xdc\xb5\xa3\
\x32\xa6\x27\x03\x00\x9b\x9c\x9b\x9e\x9e\x8e\x50\x28\x08\x45\x51\
\xe0\xf7\xfb\x51\x53\xf7\x83\xd6\xe7\xf1\xac\x7e\x37\x7f\xb3\x73\
\xb4\xe7\xbd\xf9\xbd\x2d\x4e\xef\x40\xff\xea\x9a\xda\x1a\x2d\x30\
\x14\x80\xcd\x66\x43\x6b\xfb\x6d\xa4\xa6\xa5\xc2\x30\xcc\x17\x12\
\x4a\xa4\xaa\xe2\x70\x57\x4f\x37\x18\x40\x7b\x47\x3b\xaa\x6b\xab\
\x06\x82\xfe\xa1\x85\x9b\x0b\xb6\x1c\xba\xdf\x1f\xfa\x70\xcb\xc7\
\x87\x42\xc3\x81\x85\xb5\xb5\x35\x03\xed\x1d\x6d\xb0\x8f\xb7\xc3\
\x7d\xe3\x26\x34\xa1\x9f\x89\xe9\x28\x11\x8a\xb6\xb3\xa2\xe2\xa0\
\x29\x49\xbc\xca\x60\xd3\xc2\xcc\x37\x99\x25\xe3\x41\x9f\x14\x00\
\xc4\xb0\x08\xb3\x85\xba\xea\x8f\x1f\x57\x65\xc0\x6a\x9a\x66\xb5\
\x4d\xd1\xb7\x25\x00\x0a\x0a\xb6\xf6\x00\x28\xf8\x6c\xe7\xf6\xc5\
\x6f\xbd\xb9\xca\xe1\xf3\x0d\xbc\x58\xdf\x70\x6c\x37\x80\x9c\x6d\
\x3b\xb6\xe5\xc8\xcc\x45\xcc\x3c\x3f\xde\x03\xe0\x92\xc9\xc8\x73\
\x6e\x77\xfe\x4e\xa6\x51\xf1\xf6\xca\x35\x8e\xfe\x7e\x0f\x8e\xd5\
\xd7\xff\x51\xb8\x73\x77\xde\xc8\x00\x12\xa6\xa9\x20\xe1\xc8\xc8\
\xc8\xc0\xe4\xc9\x93\x40\x82\xe6\x03\x80\xa9\xeb\x5f\x6d\xd8\x98\
\x97\x95\x3e\xe5\xd1\xb8\x9e\xfb\xd6\x8d\xac\x03\xe5\x07\x8a\x00\
\xe4\x08\x32\x1c\x33\xa6\x67\xc2\x6e\xb7\x83\x48\xcc\xff\x77\x86\
\x09\x00\x12\x04\x66\xc0\x30\x0c\x10\x51\xe4\xcc\x30\xb2\xd2\xa7\
\xa4\xc3\xeb\xf5\xc0\x30\x08\xcc\x8c\xe4\xe4\xe4\xb8\xb3\x98\x0d\
\x11\xc5\x6d\x46\x4a\xc2\xb8\x26\x8a\x38\x20\x22\x88\x18\x80\x22\
\x0e\x74\xa1\xa1\x78\xcf\xe7\x10\x51\x47\xf1\x00\x48\x80\xc1\x20\
\x43\xc4\x6d\xee\x53\x22\x02\xc0\x20\x12\x20\x21\x50\xf0\xfe\x26\
\x66\x44\x56\xc4\xa9\x00\x19\x04\x36\x4d\x08\x41\xd8\x98\xb7\x81\
\x11\xed\x0b\x11\x81\xc4\x3d\x00\x92\x24\x49\x00\xe4\x4d\x05\x79\
\x11\x65\x83\xf0\xe9\x76\x27\x14\xc5\x0a\x80\x81\x11\x59\x11\x09\
\x30\x33\x76\x39\x0b\x61\xb5\xda\x12\xee\x89\x08\x92\x24\x59\x00\
\x98\x1c\x9d\x41\xb1\x0c\x64\x00\xc9\x9a\xaa\xfe\x79\xe5\x6a\xf3\
\x73\x29\x29\x13\xd1\xd5\x73\x07\x6c\x9a\xf1\x9f\x7b\xbb\xb5\x15\
\x24\x08\x6e\xb7\x1b\x19\x19\x19\x68\xeb\xb8\x0d\x36\x4d\x98\xd1\
\xfb\xd6\xb6\x36\x68\x9a\xda\x02\x60\x02\x80\x10\x00\x03\x00\xa4\
\xe8\xb6\x02\x78\x64\xc1\xcb\x0b\x96\xcc\x98\xfe\xc4\x47\x8a\xa2\
\x64\x26\xcc\x74\x30\x34\x4d\x6b\xf6\xfb\x03\x8d\x29\x29\xa9\x4b\
\x14\xc5\x92\x19\x3b\x8f\x8d\x7c\x5d\xd3\x9a\x3b\x3a\xef\xec\xb9\
\x70\xee\xc2\x4f\x00\x06\x98\x59\x00\xd1\x69\x1a\x4d\x2b\x19\x40\
\x1a\x00\x5b\x14\xfa\xb0\xc2\x00\x34\x00\x83\x00\x42\xcc\x6c\x8c\
\x04\x48\xd1\x32\x59\x47\x64\xf5\x5f\x00\x26\x00\xc2\x88\x1e\xfc\
\x0d\x12\x88\x87\xbd\xe9\x72\xa9\x8b\x00\x00\x00\x00\x49\x45\x4e\
\x44\xae\x42\x60\x82\
\x00\x00\x03\xc2\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x12\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4e\x65\x77\x20\x42\x6f\x6f\x6b\
\x6d\x61\x72\x6b\x1e\x9b\xd5\xa0\x00\x00\x03\x21\x49\x44\x41\x54\
\x48\x89\xb5\x95\x4d\x88\x5b\x55\x14\xc7\x7f\x37\xc9\xe4\x3b\x69\
\x86\x64\x66\xea\x44\x28\x0a\x2e\xac\x0b\xad\x0b\x41\xba\xd0\x95\
\x5d\xb4\x50\x45\x5c\x74\x21\xd8\x5d\x37\x32\x4b\x41\x17\x75\xa3\
\x82\x2b\xa1\x2b\x5d\x74\xa1\x0b\xa1\x2d\xad\x15\x44\x94\x82\x51\
\x10\x2b\xd8\x76\xec\x6e\xd4\xd2\x99\xc4\x3a\x49\x93\xbc\xf7\x66\
\x32\xf7\x7d\xe4\x7d\x1c\x17\xe9\x68\x27\xed\x24\x4f\xad\x07\xde\
\xe2\xbe\xf3\xbf\xe7\xf7\xfe\x87\x77\xee\x55\x22\xc2\xff\x19\xa9\
\x49\xc9\xcd\xd3\x07\xda\x88\x5a\xd8\x55\x90\x90\x4e\xf9\xf8\x63\
\x75\x38\x13\xee\x26\x51\x93\x1c\xf4\x4f\x3d\x21\xb3\x07\x5f\x05\
\x76\x6a\x64\x66\x0b\x95\xd1\xe8\xf6\x77\x38\xb3\xe6\xd5\x5c\xa1\
\xf4\x6d\xa9\xf4\xc8\x27\xcc\x5d\xbc\x76\xcf\x37\x4c\x72\x30\xb4\
\x5d\x28\xd6\x41\x25\xfe\x7e\xf2\x06\x94\xdb\x84\xc5\x55\x86\xb5\
\xdf\x29\x3d\xf4\xc6\xd3\xae\xbe\xbd\xe4\x78\xd6\xc9\xb0\x7d\xf4\
\x95\xf1\x1a\x13\x5b\x34\xb4\x3d\x54\x7e\x11\xd4\x48\x26\xa9\x36\
\x64\x6c\x48\xf5\xf1\xf4\x0a\xf9\xf9\x37\xc9\xd5\x4e\x20\x22\x09\
\xcf\x38\x75\x34\x3d\x3b\x1b\x04\xbd\x97\xba\xa9\xda\x85\x46\x3c\
\x07\xda\x05\x35\x03\x32\x92\x0d\xa3\x1f\x31\xcd\x33\x58\xdd\x06\
\x61\x58\x24\x5b\x3d\x01\x40\xae\xfa\x1a\x41\x98\xa6\xd3\x6a\xbc\
\xdc\x6d\xfd\x70\xb6\x79\x39\x7f\x30\x96\x03\xdf\x76\xc1\x77\x11\
\xc7\x82\x94\x66\x10\x7d\x43\xe5\xd1\xcf\x99\x29\x3c\xbb\x43\xa7\
\x12\x39\x6a\xfb\x97\x21\x1a\xe0\x18\xe7\x6a\xfd\x5f\x97\xce\x02\
\x8b\x53\x1d\xf8\x8e\x87\xf8\x2e\x62\x9b\xe0\xf7\x48\xa7\xf6\xa2\
\x3b\x1f\x80\xf8\xf7\x51\x07\x10\x0d\xb0\x8d\xcf\x42\x95\xca\x5f\
\x89\xd5\x22\x89\x04\x02\x0f\x71\x4c\xc4\xb1\x29\x66\xf6\x23\xde\
\x35\x36\x5b\x4b\x63\x42\x17\x42\x03\xe3\xe6\xeb\x84\xce\xf5\xce\
\xdc\xbe\x03\x6f\x6d\xa7\x26\xb6\x08\x40\xbc\x2d\xc4\xb6\x90\xa1\
\xa0\xca\x90\xcc\x14\x90\x48\x41\xd8\x05\x14\x10\x20\xe2\x82\x68\
\xa2\x40\x93\xcd\xed\xb9\x9a\x4e\x67\x9b\xf1\x01\x8e\x85\x38\xe6\
\x68\x61\x86\x04\x65\x9f\x54\x25\x85\x04\x4d\xb4\xf1\x15\xb6\xf1\
\x05\x85\xea\x61\xf2\x95\x67\x50\x2a\x23\xb6\x36\x8c\x72\x65\xd9\
\x8a\x05\x10\x91\x51\x7b\xec\x3b\xfa\xa6\x22\xbf\x6f\x8e\xbe\xfd\
\x31\x1b\xb7\x4e\x93\x2d\x2c\x90\x2f\xd6\x18\xac\x7f\x44\xef\xb7\
\x77\x22\x54\x72\x90\x2d\x2d\xbe\x7d\x77\x8d\xa9\x0e\xb0\x0d\xb8\
\xe3\x40\x1c\x48\xfc\x92\x64\x7e\xf1\x49\xd4\xc3\x75\xb6\x7a\x37\
\x51\x95\xea\xa5\xb9\xfa\xde\x1b\x08\x3f\xd9\x41\xe2\x42\xa9\x7e\
\xbe\xff\x8f\x00\xa2\xfb\xa3\xbf\x68\x7b\x6d\x03\x26\x24\xf5\x3c\
\x9d\x2b\x2b\xac\x3d\xf5\xf8\xfb\x2f\x3c\x57\xbd\xce\xc2\xc5\x4e\
\xe9\x3e\xfb\x63\x00\xba\xa3\x39\x18\x8b\xc8\xea\x63\xb7\x2c\x0e\
\xbd\xfb\xfd\xcf\x22\x72\x7b\xb7\xfd\x53\x00\x82\x6c\x75\x77\x38\
\xf8\x2b\x33\xe8\x32\x7e\x08\xfe\x0b\x00\x88\x6f\x83\x44\xa8\x7c\
\x15\x32\x65\x70\x37\x10\xc7\x18\xbd\x8f\x11\x13\x07\x0d\x00\xdf\
\x41\x65\x2b\xb8\x7e\x82\x1b\x2b\x2d\xdb\x0d\x92\xa8\xec\x1e\x08\
\x9c\x07\x00\x10\x81\xc0\xc5\xf1\x84\xb5\xd5\x9e\xfe\xc3\x0c\xde\
\x5b\x5b\xed\x69\xc7\x1b\x4d\x38\x31\x6e\xc3\xa9\x0e\x9c\x81\xa6\
\xd9\xda\xd0\xcb\x5d\x39\x76\xe8\x3c\x1f\xde\xd2\xf2\x62\xb3\xb5\
\xa9\x9d\x81\x7e\x00\x0e\x80\xe6\xba\xab\x97\x7b\x1c\x3b\xfe\x25\
\x97\x01\xeb\xf0\x39\xb9\x64\xf9\x1c\x69\xae\xbb\xb1\x08\x13\x01\
\x89\x04\x5f\xdf\x5d\x5c\x64\x74\x8c\x3e\xff\xa9\x34\x2c\x9f\x23\
\x81\xd0\x98\x06\x98\x78\x27\x03\x28\xa5\x2a\x80\xde\x2e\x3e\x96\
\x9b\x01\x0a\x22\x72\xef\xa0\xc4\x05\xfc\xd7\xf8\x13\xc1\x51\xa5\
\x2f\x0d\xab\x7d\x3f\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\
\x82\
"

qt_resource_name = "\
\x00\x05\
\x00\x6f\xa6\x53\
\x00\x69\
\x00\x63\x00\x6f\x00\x6e\x00\x73\
\x00\x09\
\x00\x57\xb8\x67\
\x00\x70\
\x00\x72\x00\x69\x00\x6e\x00\x74\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x08\
\x07\x9e\x5a\x47\
\x00\x62\
\x00\x61\x00\x63\x00\x6b\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0b\
\x08\x5d\x84\xe7\
\x00\x66\
\x00\x6f\x00\x72\x00\x77\x00\x61\x00\x72\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0a\
\x05\x78\x4f\x27\
\x00\x72\
\x00\x65\x00\x6c\x00\x6f\x00\x61\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0c\
\x08\x1a\x9d\x27\
\x00\x64\
\x00\x6f\x00\x77\x00\x6e\x00\x6c\x00\x6f\x00\x61\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0b\
\x03\x03\x9b\x47\
\x00\x7a\
\x00\x6f\x00\x6f\x00\x6d\x00\x2d\x00\x69\x00\x6e\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0c\
\x06\xeb\x97\xe7\
\x00\x7a\
\x00\x6f\x00\x6f\x00\x6d\x00\x2d\x00\x6f\x00\x75\x00\x74\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0c\
\x0d\x31\x7b\xa7\
\x00\x76\
\x00\x6c\x00\x63\x00\x5f\x00\x70\x00\x6c\x00\x61\x00\x79\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0b\
\x06\xb1\x20\x67\
\x00\x73\
\x00\x65\x00\x65\x00\x62\x00\x6f\x00\x6f\x00\x6b\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x08\
\x06\x38\x5a\xa7\
\x00\x68\
\x00\x6f\x00\x6d\x00\x65\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0c\
\x05\xa2\x93\x27\
\x00\x62\
\x00\x6f\x00\x6f\x00\x6b\x00\x6d\x00\x61\x00\x72\x00\x6b\x00\x2e\x00\x70\x00\x6e\x00\x67\
"

qt_resource_struct = "\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x01\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x0b\x00\x00\x00\x02\
\x00\x00\x00\x10\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\
\x00\x00\x00\x92\x00\x00\x00\x00\x00\x01\x00\x00\x17\xbf\
\x00\x00\x00\x5a\x00\x00\x00\x00\x00\x01\x00\x00\x0d\xae\
\x00\x00\x01\x1c\x00\x00\x00\x00\x00\x01\x00\x00\x2b\x2e\
\x00\x00\x01\x06\x00\x00\x00\x00\x00\x01\x00\x00\x25\xd4\
\x00\x00\x00\xea\x00\x00\x00\x00\x00\x01\x00\x00\x21\xb9\
\x00\x00\x00\xae\x00\x00\x00\x00\x00\x01\x00\x00\x1b\x1d\
\x00\x00\x00\x28\x00\x00\x00\x00\x00\x01\x00\x00\x04\xe9\
\x00\x00\x00\x74\x00\x00\x00\x00\x00\x01\x00\x00\x13\x0f\
\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x01\x00\x00\x09\x41\
\x00\x00\x00\xcc\x00\x00\x00\x00\x00\x01\x00\x00\x1e\x38\
"

def qInitResources():
    QtCore.qRegisterResourceData(0x01, qt_resource_struct, qt_resource_name, qt_resource_data)

def qCleanupResources():
    QtCore.qUnregisterResourceData(0x01, qt_resource_struct, qt_resource_name, qt_resource_data)

qInitResources()

###########################################################################################################

if __name__ == "__main__":
    import sys
    app = QApplication(sys.argv)
    MainWindow = QMainWindow()
    ui = Ui_MainWindow()
    ui.setupUi(MainWindow)
    MainWindow.show()
    sys.exit(app.exec_())
