# -*- coding: utf-8 -*-
#Albix Player Copyright (c) 2017 JJ Posti <techtimejourney.net> 
#Albix Player comes with ABSOLUTELY NO WARRANTY; 
#for details see: http://www.gnu.org/copyleft/gpl.html. 
#This is free software, and you are welcome to redistribute it under 
#GPL Version 2, June 1991")
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os, sys,pygame

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    def _fromUtf8(s):
        return s
try:
    _encoding = QtGui.QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QtGui.QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QtGui.QApplication.translate(context, text, disambig)

class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        MainWindow.setObjectName(_fromUtf8("MainWindow"))
        MainWindow.resize(906, 605)
        MainWindow.setToolTip(_fromUtf8(""))
        MainWindow.setTabShape(QtGui.QTabWidget.Rounded)
        MainWindow.setDockNestingEnabled(True)
        MainWindow.setUnifiedTitleAndToolBarOnMac(False)
        self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
        
#Grid        
        self.gridLayout = QtGui.QGridLayout(self.centralwidget)
        self.gridLayout.setObjectName(_fromUtf8("gridLayout"))
        self.verticalLayout = QtGui.QVBoxLayout()
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))

#Song listing        
        self.listWidget = QtGui.QListWidget(self.centralwidget)
        self.listWidget.setObjectName(_fromUtf8("listWidget"))
        self.verticalLayout.addWidget(self.listWidget)
        self.listWidget.itemClicked.connect(self.play)
        
#Splitter        
        self.gridLayout.addLayout(self.verticalLayout, 1, 0, 1, 1)
        self.splitter = QtGui.QSplitter(self.centralwidget)
        self.splitter.setOrientation(QtCore.Qt.Horizontal)
        self.splitter.setObjectName(_fromUtf8("splitter"))
        
#Stop button        
        self.Stop = QtGui.QPushButton(self.splitter)
        self.Stop.setText(_fromUtf8(""))
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(_fromUtf8(":/icons/media-playback-stop.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.Stop.setIcon(icon)
        self.Stop.setObjectName(_fromUtf8("Stop"))
        self.Stop.clicked.connect(self.stop)
        
#Toggle play/pause        
        self.toggle_play = QtGui.QPushButton(self.splitter)
        self.toggle_play.setText(_fromUtf8(""))
        icon1 = QtGui.QIcon()
        icon1.addPixmap(QtGui.QPixmap(_fromUtf8(":/icons/media-playback-start.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.toggle_play.setIcon(icon1)
        self.toggle_play.setObjectName(_fromUtf8("toggle_play"))
        self.toggle_play.clicked.connect(self.paused)
        
#Add songs        
        self.Add_song = QtGui.QPushButton(self.splitter)
        self.Add_song.setText(_fromUtf8(""))
        icon2 = QtGui.QIcon()
        icon2.addPixmap(QtGui.QPixmap(_fromUtf8(":/icons/list-add.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.Add_song.setIcon(icon2)
        self.Add_song.setObjectName(_fromUtf8("Add_song"))
        self.Add_song.clicked.connect(self.dialog)

#Remove songs        
        self.remove_song = QtGui.QPushButton(self.splitter)
        self.remove_song.setText(_fromUtf8(""))
        icon3 = QtGui.QIcon()
        icon3.addPixmap(QtGui.QPixmap(_fromUtf8(":/icons/list-remove.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.remove_song.setIcon(icon3)
        self.remove_song.setObjectName(_fromUtf8("remove_song"))
        self.remove_song.clicked.connect(self.deleting)

#Second navigator        
        self.horizontalSlider = QtGui.QLineEdit(self.splitter)
        self.horizontalSlider.returnPressed.connect(self.navigate)
        self.horizontalSlider.setPlaceholderText("Jump to time value (enter seconds)")
        self.horizontalSlider.setFixedSize(250, 30)
        self.horizontalSlider.setObjectName(_fromUtf8("horizontalSlider"))

#Pause / Unpause placeholder variable
        self.Paused = False

        self.gridLayout.addWidget(self.splitter, 0, 0, 1, 1)
        MainWindow.setCentralWidget(self.centralwidget)
        
        self.retranslateUi(MainWindow)
        QtCore.QMetaObject.connectSlotsByName(MainWindow)

    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(_translate("MainWindow", "Albix player", None))
        self.Stop.setToolTip(_translate("MainWindow", "Stop", None))
        self.toggle_play.setToolTip(_translate("MainWindow", "Toggle Pause\Play", None))
        self.Add_song.setToolTip(_translate("MainWindow", "Add to playlist", None))
        self.remove_song.setToolTip(_translate("MainWindow", "Remove song", None))
#Functions
#Add files   
    def dialog(self):
        for path in QtGui.QFileDialog.getOpenFileNames(None):
            print path
            item = QListWidgetItem(path)
            self.listWidget.addItem(item)
#Delete Files from playlist
    def deleting(self):
        for item in self.listWidget.selectedItems():
            self.listWidget.takeItem(self.listWidget.row(item))

#Play/Pause song
    def play(self,item):
        x=self.listWidget.currentItem()
        value = x.text()
        print value
        song=str(value)
        pygame.mixer.init()
        pygame.mixer.music.load(song)
        pygame.mixer.music.play(0,0)

#Pause / Unpause
    def paused(self,widget):
        if self.Paused:
            pygame.mixer.music.unpause()
            self.Paused = False
        else:
            pygame.mixer.music.pause()
            self.Paused = True
#Stop song
    def stop(self):
		pygame.mixer.music.stop()       


    def navigate(self):
        self.x=int(self.horizontalSlider.text())
        pygame.mixer.music.play(0, self.x)            
                                                                                 
#######################ICONS
qt_resource_data = "\
\x00\x00\x03\x1e\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\x7c\x49\x44\x41\
\x54\x48\x89\xed\xd5\xdf\x4b\x53\x61\x18\x07\xf0\xef\x7b\xb6\x9d\
\xf7\xa8\x67\x53\xcf\xd1\x43\xed\xcc\x65\x6d\xb0\x8b\x6d\x6a\x28\
\xcb\xd9\xea\x90\x42\x37\xd2\x7e\x38\x58\x74\x91\x82\x17\xdd\x34\
\x24\x24\xbc\x0b\xd9\x85\x04\xd1\x55\xd0\xad\xa0\xfd\x20\xa2\xd4\
\x52\xe9\xa2\x88\xfe\x01\x03\x47\xdd\x68\xde\x85\x44\x92\x0a\xa9\
\xe7\x75\xce\xad\x1b\x37\x66\x6e\x9a\x81\x50\xd4\x03\xe7\xea\x73\
\x78\xbe\x0f\x2f\xef\x73\x0e\xc9\x66\xb3\x38\xca\xe2\x8e\xb4\xfb\
\xff\x80\xbf\x2b\x80\x10\xc2\x29\x8a\x22\xca\xb2\x6c\x21\x84\xf0\
\xa5\xbc\xb2\xb2\x52\x22\x84\x08\x79\xc8\x66\xb3\x07\x3e\x2e\x97\
\xcb\x1c\x8d\x46\x4f\x3d\x1f\x7f\x72\xef\xd5\xeb\xa9\xa4\xcb\xe5\
\xb2\x16\xba\xdb\xed\x16\x0b\xbd\xb1\xb1\x51\xcd\x99\x71\xbf\xa9\
\x83\xc1\x60\xb9\xc1\x60\x50\x6e\x0e\xf4\x77\x1e\x57\x8f\x25\x1c\
\x27\x9d\x96\x4f\x0b\x73\x26\x87\xc3\x21\x16\xfa\x8d\xfe\xbe\x5d\
\xae\xaa\x6a\x45\xae\x47\xd1\x80\x58\x2c\xc6\xab\xaa\x6a\xd5\xda\
\xb5\x26\x7b\x9d\x35\x61\xb3\xd7\xb9\x1a\xdc\x4d\x54\xa0\x65\xf8\
\xf0\x31\x09\x87\xc3\x51\x16\x8f\xc7\x4f\x68\xed\xda\xe9\x52\x5e\
\x34\x20\x91\x48\x70\x66\xb3\x59\x0d\x04\x02\xce\x6a\x49\xbc\x2e\
\xd7\xd4\x5c\x6a\x3d\x73\xd6\x44\x29\x25\xa9\xd4\x26\x78\x9e\x82\
\x31\x86\xfa\xfa\xfa\x9a\x5a\xa5\xea\x56\x29\xb7\xd9\x6c\x45\x03\
\x88\xd7\xeb\xf5\x7d\x5f\x5f\x89\x50\x9e\x8f\xfb\xfd\xe7\x04\x59\
\x96\xb9\x54\x6a\x13\xe9\x74\x1a\x94\x0a\x30\x70\x06\x30\x9d\xc1\
\x6a\xab\x7d\xe9\x6f\x2d\xe1\x8c\xc1\xe9\x74\xee\x0d\x98\x99\x99\
\x91\x39\x0e\xe7\x01\x32\x10\x09\xc7\xb0\xa1\xaf\x61\x43\x5f\x87\
\x40\x05\xf0\xbc\x00\xde\x64\x02\xc7\x71\x30\x99\x78\x44\x42\xb1\
\xf2\x52\xce\x74\x06\xbb\xd7\x9e\x0f\xc8\x5f\xd3\xe6\xe6\xe6\x6f\
\x6d\x6d\x81\x59\x51\x14\xef\x8f\x3e\x1a\xd6\x57\x56\x57\x33\xe6\
\x0a\x0b\x28\x15\x40\x79\x0a\x8e\x33\x00\x00\x96\x96\xbe\x62\x3f\
\x67\x8c\xc1\x6e\xb7\x17\x3d\xa2\xac\xa2\x28\x6f\xa2\x91\xd8\x97\
\xe5\xe5\xe5\xf7\x93\x53\x13\x57\xb6\x33\x19\x2d\x1c\xea\x32\xf2\
\x55\x94\xe4\x5e\x62\x8c\xa1\x37\x7c\xad\x6f\x72\x6a\xe2\xf2\x76\
\x26\xa3\x85\x83\x5d\x46\xbe\x7a\xb7\x2b\x8a\x92\xdf\x83\x9f\x17\
\x6d\x1b\xc0\xac\x24\x49\x4f\x7b\xba\x7b\x6f\xfb\x5a\x7c\x83\x23\
\xa3\xc3\x0b\x63\xe3\xcf\xb6\x74\x5d\xcf\x37\x90\x24\x69\xab\xa7\
\xbb\x77\xc8\xd7\xe2\x1b\x1c\x79\xb0\xd7\x0b\x07\x2f\xb5\x07\x6b\
\x00\xde\x7a\x3c\x0d\x73\x1e\x4f\xc3\xfc\xf4\xf4\x8b\x0b\x77\xee\
\x0e\x5d\xed\x68\xbf\x58\xc6\x18\x33\x02\x30\x01\x78\x77\x80\xef\
\x1b\x90\xab\xcf\x00\xc6\x3a\x3b\x43\xf3\x9a\xd6\x91\x7c\xf8\x78\
\x34\x64\x16\x2d\x6e\x00\xe9\x1d\x5f\xdc\xf1\xb9\x12\x0e\x72\x88\
\x3f\x5a\x39\x00\x3f\x00\x0b\x80\x24\x80\x85\x5f\xf1\xc3\x04\xfc\
\x56\xfd\x39\x9f\xeb\x7f\x37\xe0\x07\xcd\x83\x23\x99\x70\x09\xb0\
\x8f\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x4a\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\xa8\x49\x44\x41\
\x54\x48\x89\xed\x95\xdf\x4b\x93\x51\x18\xc7\xbf\x67\x6e\xef\xd9\
\xeb\x5e\x15\x1c\xbc\xa2\xef\x5a\xd8\xbb\x78\x75\xfe\xd8\x45\xd4\
\x45\x77\x65\x1a\x04\x51\x73\xe0\x45\xd0\x45\x50\x5d\x8d\x62\x51\
\xd1\x9d\x7f\x41\x44\x85\x74\x55\x14\x16\x14\x41\xe1\x34\x23\xc1\
\x4c\xfa\x31\xed\xa6\x48\xcb\x6b\x67\x33\x73\x10\x39\x68\x3b\xed\
\xbc\x7b\x4f\x17\x6e\xeb\xc5\x72\x5e\x09\x11\x1e\x38\x17\x87\xcf\
\xe1\xfb\xe1\x79\xce\xe1\x1c\x22\x84\xc0\x66\x0e\xc7\xa6\xa6\x6f\
\x09\xfe\x09\x81\x13\x00\x08\x21\xee\xda\xda\xda\x6a\x4a\x69\x3e\
\x9d\x4e\x67\x85\x10\x96\x7d\x13\x21\x44\xaa\xaf\xaf\x77\x57\x55\
\x55\x59\x7f\xe3\xf6\x0c\x21\x04\x21\x84\x88\x4c\x26\x93\x15\x42\
\x30\x08\x21\x10\x0a\x85\xb4\xa7\x63\x23\x1f\x1e\x3e\xbe\x7f\x2d\
\x12\x89\xec\x68\x6b\x6b\x53\x84\x10\x28\x4d\xc3\x30\x9a\xec\xdc\
\x30\x8c\x1a\x3b\x2f\x65\x8c\x8d\x8f\x8a\xd2\x0c\x85\x42\x9a\x10\
\x62\xb5\x02\x4d\xd3\x3c\xa6\xc9\x3b\x82\x2d\xc1\x96\x13\xa7\x8e\
\x1f\xfb\x92\xfa\xda\x1f\x0e\x87\x9f\x14\x0a\x85\xe5\x78\x3c\x9e\
\xd5\x75\x5d\xa9\xc4\x4b\x19\x9c\x9b\x38\x74\xf0\x30\x46\x9f\x0d\
\x43\xd3\x34\x4f\xb9\x45\xba\xae\xcb\x8c\x31\xec\xd4\x0d\x97\xaf\
\xc9\xef\x9d\xfd\x34\x73\xb9\xae\xae\xe6\x74\x72\x61\xb1\x3f\x1a\
\x8d\xbe\xab\xc4\x63\xb1\xd8\xfb\x54\x2a\xb5\xa8\xeb\xba\xcc\x39\
\x87\x10\x02\x9c\x73\xe8\xba\x2e\x97\x05\x3e\x9f\x4f\x66\x8c\x21\
\xf7\x33\x87\xd4\x52\x12\xad\xad\x41\xda\x6a\x04\x3b\x12\xd3\xaf\
\x1f\xa8\xaa\x77\x38\xbd\xf4\xed\x46\x25\xde\xdc\xdc\x3c\xc0\x18\
\xcb\xd9\x05\x3e\x9f\x4f\x06\x8a\xb7\x28\x10\x08\xc8\x8c\xb1\xd5\
\x53\x77\xba\x90\xcd\xfd\x00\xa9\x22\xe4\xc0\xfe\x1e\xa9\x6b\x5f\
\x77\x58\xdb\xd6\x10\xaf\xc4\x1b\x1a\xbd\x23\x0d\x8d\xde\xb0\x5d\
\x10\x08\x04\x7e\x0b\xfc\x7e\xbf\xcc\x72\x0c\x04\x04\x94\x52\xb8\
\x25\x37\xa8\x44\x21\x49\x14\x4d\x8d\x9a\xa3\xf7\x68\x5f\xb5\xcb\
\x29\x55\xe4\x00\xb9\x68\x17\xf8\xfd\xfe\x35\x02\xc6\xe0\x70\x38\
\x20\xb9\x28\x24\x4a\x41\x25\x37\x4c\xd3\x44\x32\x39\x6f\xdd\xb9\
\x7b\x33\x97\x4e\x2f\x57\xe4\x8a\xa2\x0c\xac\x0a\xac\x3f\x05\xaa\
\xaa\xba\x19\x63\x20\x84\x40\x92\x24\xc8\xb4\x1a\x2b\x2b\xdf\xc5\
\xe0\xbd\xdb\xfc\xc5\xe4\xf8\xf3\xde\x23\x7d\x67\x36\xe0\xd1\x48\
\xb8\x2f\xc1\xf3\xc5\x0a\xf2\x1c\xaa\xaa\xba\xcb\x87\x0c\xc0\xc9\
\x18\x03\x95\x28\xac\x82\x85\xa1\xf8\x23\x9e\x5c\x48\xce\x77\x77\
\xf5\xdc\x6a\x6f\xef\x4c\x00\xd8\x5e\x81\x4f\x03\x78\x0b\x20\x62\
\x6f\x51\x29\xbb\x24\x70\x31\xc6\xf0\xf2\xd5\xa4\x39\x31\x39\x91\
\xdb\xb3\x6b\xf7\x60\xec\xec\xf9\x09\x00\x6f\x00\x2c\x02\x38\xb9\
\x0e\x9f\x02\xf0\xb9\x94\xb1\x46\xe0\xb2\x0b\x4c\x8f\xc7\x93\x9c\
\x9b\x9b\xfb\x78\xe1\xdc\xa5\x21\x45\x51\x12\x00\x66\x01\x58\xeb\
\xf0\x29\x00\x33\x36\x0e\x00\x16\xe7\x1c\x57\xaf\x5f\x29\xaf\x01\
\x80\x14\x7f\x34\x1d\x40\x27\x80\x0c\x80\x04\x80\xec\x9a\xa7\x66\
\x23\x0e\x00\xed\x00\xf6\x02\x90\x00\xe4\x8b\xd5\xcf\x92\xad\x2f\
\xf3\xff\x17\xfc\x02\x14\xfc\xc4\x73\x3e\xcb\xd8\xa5\x00\x00\x00\
\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x04\xf8\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x04\x56\x49\x44\x41\
\x54\x48\x89\xb5\x96\x4d\x68\x54\x57\x14\xc7\x7f\xf7\xbd\x37\xf3\
\x26\x89\x99\x4c\x66\x34\x89\x89\x4e\x05\x25\x31\x10\x53\x4d\x5a\
\x74\x53\xb0\x44\xa8\x14\x5c\x94\x52\x17\xa5\xab\x40\x91\x2e\x0a\
\x5d\xc4\x24\x8d\x14\x2c\x74\x55\x14\x0a\x6e\x14\xea\x26\x15\x02\
\x2a\x6d\xa0\xe0\xa6\x12\x42\x37\x2a\x6a\x15\x23\x68\x85\x6a\xe2\
\x18\x9b\xcf\x89\x99\x79\x33\x93\xbc\x37\xf7\x9e\x2e\x82\xd3\x4c\
\x3e\x4a\x37\x3e\xb8\x8b\x77\xee\x7b\xff\xdf\xe5\x7f\xee\x39\xf7\
\x2a\x11\xe1\x4d\x3e\xd6\x1b\x55\x07\x9c\xff\x9a\xbc\xa2\x94\x5d\
\x84\x0f\x81\x83\x36\x1c\xd6\xd0\x0e\x60\xc3\x03\x0d\xa3\xc0\x2d\
\x07\xae\x7d\x22\xa2\x37\xd3\x50\x9b\x59\xf4\x93\x52\xad\x61\xb8\
\x5a\x19\x8d\xbe\xd5\x10\x8d\x46\x62\x95\x95\x76\xd4\x75\x21\x08\
\x78\x95\xcd\xb2\xe0\x79\x7a\x26\x9f\x2f\xe4\x83\x60\xa2\x08\x1f\
\x7f\x26\xf2\xe7\xff\x02\x7c\xab\x94\xb5\x07\xfa\x1c\xdb\x3e\xd5\
\xd6\xdc\x5c\xb1\x3d\x91\xb0\xac\xa9\x29\xac\x4c\x06\x15\x8b\x81\
\x08\x6a\x76\x16\xed\x38\xe8\x70\x98\xe7\x9e\x67\x1e\x67\xb3\x05\
\x23\x72\xfa\x53\x38\xcb\x5a\x41\x11\x29\x1b\x97\xe0\xeb\x5f\x63\
\xb1\xdc\x8b\xae\x2e\x99\x69\x6f\x97\xd9\xce\x4e\xc9\x0c\x0f\x8b\
\x97\x4a\x49\x2e\x97\x93\x5c\x2e\x27\x5e\x2a\x25\x99\xe1\x61\x49\
\x77\x74\xc8\x74\x4d\x8d\x3c\x8d\xc5\xe4\x17\xcb\xca\x5e\x82\xfe\
\xb5\x7a\x65\x2f\x83\xd0\x3a\x64\xdb\xf9\x89\xa3\x47\xe5\x45\x32\
\x29\x33\xfd\xfd\xb2\x38\x37\x27\x9e\xe7\x49\xa1\x50\x90\x3f\xce\
\x9d\x93\xdf\x7b\x7b\xc5\x5b\x58\x10\xcf\xf3\x24\x33\x3f\x2f\x73\
\xfd\xfd\x32\x59\x51\x21\x4f\xaa\xaa\x64\x08\x72\x83\xd0\xba\x5a\
\xb3\xb4\x8b\xae\x28\x65\x3b\x70\xb5\x65\xff\x7e\xd7\x4a\xa7\xb1\
\x8e\x1d\x23\xd4\xd7\x87\xe5\xba\x58\x96\x85\x12\xe1\xf1\xe0\x20\
\x2f\x46\x46\x78\xf5\xe4\xc9\x4a\x2c\x1c\xc6\xee\xeb\xc3\xee\xee\
\x26\x6c\x0c\x49\xc7\x89\x84\xe0\xf2\x15\xa5\xec\xd7\xba\x25\x80\
\x0f\x5d\x5b\x12\x89\xe4\xb6\x64\xd2\x0a\x72\x39\xc2\x03\x03\x28\
\xa5\x4a\x56\x5a\x8e\x43\x24\x1e\x07\xa0\xaa\xae\xee\xdf\x24\x2a\
\x85\x33\x30\x80\x24\x93\x6c\xb3\x6d\xcb\x81\xa4\x0f\x5d\xeb\x00\
\x0a\x0e\xc6\x1b\x1a\x2a\xfd\xc9\x49\x9c\xee\x6e\x70\xdd\x32\xfb\
\x8c\x31\x54\x35\x36\x62\x85\xc3\x44\xea\xeb\xcb\xf2\x87\xeb\xe2\
\x9c\x38\x81\x31\x86\x28\x44\x2c\x78\x77\x23\xc0\xfb\x55\x5b\xb7\
\x5a\x41\x3a\x8d\xd5\xd6\xb6\x2e\xf9\xc6\x18\x2a\xb7\x6f\xa7\x7a\
\xe7\x4e\x04\x30\xc6\x94\xcd\xab\xf6\x76\xb4\x08\x15\x4a\x85\x81\
\xc3\xaf\x75\x57\x17\xda\xdb\x95\x89\x04\xc1\xa3\x47\x58\x2d\x2d\
\x18\x63\x50\x4a\x95\x6c\x12\x11\x2a\x1b\x1b\xd1\xbe\x8f\xd6\x1a\
\x63\x4c\xd9\x50\xcd\xcd\x98\x50\x08\xd7\x18\x10\xe9\xd8\x08\xa0\
\x0c\x50\x2c\x16\xd1\x85\x02\xca\x75\xcb\xc4\x45\x84\x48\x7d\x3d\
\xc6\x98\x0d\x01\x66\x69\x09\x1d\x04\xac\x2d\xe9\xd5\xbd\xe8\x7e\
\x6e\x7e\x1e\x15\x8f\xe3\x3f\x78\x50\x26\xa4\xb5\xa6\x58\x2c\xe2\
\xd6\xd5\x51\xd1\xd4\xb4\xb2\x88\x55\x73\xc6\x18\x8a\x63\x63\x68\
\x20\x2f\x82\x82\x7b\xeb\x00\x06\x46\x33\x73\x73\x46\xc5\xe3\x2c\
\xdf\xb9\x53\x5a\x99\xd6\xba\x34\xaa\x5b\x5a\xd8\x7a\xe8\x50\x59\
\xec\xf5\x77\x4b\x37\x6f\xa2\x95\xa2\x20\xe2\x9b\x95\x3e\xb5\x2e\
\xc9\xb7\x16\xa7\xa6\xf2\x4e\x53\x13\x99\x8b\x17\x09\x52\xa9\x32\
\x21\xad\x35\x7f\x8f\x8e\xf2\xec\xf2\xe5\x75\xf1\x20\x95\x22\x73\
\xe1\x02\x45\xa5\xc8\xc1\x12\x70\x7b\x1d\x20\x04\xd7\xf3\xf3\xf3\
\xcf\xd3\x13\x13\xc6\xdd\xbd\x9b\x74\x4f\x0f\x3a\x08\x4a\x76\x14\
\x8b\x45\x66\x6e\xdc\x60\x6a\x64\xa4\x2c\xa6\x83\x80\x85\x93\x27\
\xd1\xbe\xcf\x82\xd6\xc6\xc0\xf3\x10\x5c\x2f\x2d\x7c\x75\x6f\x3a\
\xaf\x54\x5b\xd4\xb6\x6f\xb7\x1e\x39\x12\x59\x7e\xf8\x10\xbb\xa1\
\x81\xf8\x99\x33\xd8\xbb\x76\xad\x24\xdb\x18\xd0\x1a\x15\x0a\x01\
\xa0\xc7\xc7\x49\xf7\xf4\xe0\x8f\x8d\x11\x38\x0e\x93\xf9\x7c\xe1\
\x29\xbc\xf7\x8d\xc8\xdd\x0d\x01\x4a\xa9\x9a\x1f\xe0\xd4\x8e\xda\
\xda\x2f\x77\x75\x76\x46\xcc\xf4\x34\x4b\xe3\xe3\x6c\x39\x7e\x1c\
\xf7\xc0\x01\xc2\xfb\xf6\x01\xe0\x8f\x8d\xe1\xdf\xbb\x47\x76\x68\
\x08\xe5\x38\x04\x4a\x31\x9d\xcd\x16\x52\xc6\x9c\xef\x85\xef\x81\
\xb4\x88\xf8\x1b\x02\x22\x90\x38\x0d\x5f\xed\xb0\xed\xcf\x1b\xf7\
\xee\x75\xab\x6b\x6b\x95\xff\xf2\x25\x3a\x93\x41\x7b\x1e\x4a\x64\
\x65\x0b\x3b\x0e\xca\x75\xc9\xe4\x72\x92\xce\x66\x97\x9f\x89\xfc\
\xf8\x1d\x9c\xf7\x61\x1e\x98\x17\x91\x60\x23\x80\x0d\xc4\x80\x9a\
\x8f\x60\xff\x31\x38\x5b\x15\x8d\x36\x54\x45\xa3\xe1\x48\x45\x85\
\x15\x76\x5d\x4c\x10\xb0\x9c\xcd\x52\xc8\xe5\x4c\xbe\x50\xf0\xf3\
\xbe\x3f\xfd\x33\xf4\x5e\x83\x87\xc0\x22\xb0\x28\x22\xde\x86\x16\
\xad\x02\x45\x80\x9a\x28\x54\x7f\x01\x1f\x24\xa0\xa3\x16\xde\x71\
\x61\x0f\xc0\x12\xfc\x95\x86\xbb\xb3\x70\xff\x02\xfc\xe6\x41\x06\
\xf0\x80\xac\xac\x39\x3e\x37\x3d\x32\x57\xc1\x42\x2b\x9b\x8c\x10\
\x2b\x95\xaf\x00\x0d\x14\x81\x00\xf0\x45\xc4\x6c\xfa\xff\x9b\xbe\
\xb6\xfc\x03\x33\xbd\xcb\xe4\x9d\x3c\xf8\x03\x00\x00\x00\x00\x49\
\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x7d\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\xdb\x49\x44\x41\
\x54\x48\x89\xdd\x95\x4d\x68\x13\x41\x14\xc7\xff\xb3\xdd\xd9\xee\
\x66\x93\x46\xdb\x74\xad\x92\x6e\x88\x89\x16\xa1\x45\xc4\x2f\x0c\
\xc5\x93\x9f\x2d\x08\x22\xa8\x07\x2f\x5e\xed\x41\x0a\x0a\x52\x90\
\x14\x0f\x62\x4f\xb9\x08\x1e\x14\x41\x91\x8a\x9f\x58\xa4\xd1\x8a\
\xd1\x56\xd1\x56\x25\x42\xb1\x68\xc5\x4a\xd2\x5a\xf4\xa0\x6d\x6c\
\x4c\x9a\xc9\x6e\xb2\xe3\xc1\x0f\xd0\x44\xd3\x16\x3d\xe8\x83\x77\
\x19\x86\xdf\x8f\xf7\x78\x6f\x86\x70\xce\xf1\x37\x43\xf8\xab\xf4\
\xff\x42\x20\xfe\x7c\x40\x08\x91\x00\xc8\x00\x4c\x00\x59\xce\xb9\
\xf5\x47\x05\x00\xe4\x5b\xb7\xbb\xfb\xb2\x86\xd1\x77\xa1\xf3\x4a\
\x07\x21\x24\xf1\x55\x34\xb7\x69\xe0\x9c\xff\x90\x0e\x87\xa3\xea\
\x56\x24\xcc\xc7\xdf\x8e\x19\x91\xde\x9e\xe4\xe5\xab\xe7\x5b\xfd\
\x7e\x7f\x35\x00\xf9\xe7\xbb\x33\xc9\x82\x0a\x3c\x1e\x8f\x0d\x00\
\x6a\xb4\x85\xd4\x55\x59\x4d\xc7\xc6\x47\x8f\x9d\x38\x79\xbc\x35\
\x1e\x8b\xb7\xd5\xd7\xd7\xdf\x4e\xa7\xd3\x1f\x63\xb1\x18\x9b\x73\
\x8b\x74\x5d\x57\xb2\xd9\x2c\xf2\x79\x0b\xc9\x4f\x53\xa8\x76\x69\
\xd2\xc2\x9a\x45\xb5\xf3\x2a\x9c\xa7\x8e\x76\x1c\x79\x36\x34\x34\
\xdc\xde\xd4\xd4\x34\x08\xe0\x7d\x38\x1c\xce\xce\x5a\xe0\xf3\xf9\
\x14\xc6\x18\x38\x38\x0c\xd3\x40\x7a\x3a\x85\x5c\x3e\x07\x8f\xc7\
\x5b\xbe\xd8\xbb\x64\xa5\x6a\x53\xaf\x7a\xbd\xb5\x3d\xaf\x46\x62\
\xa1\x96\x96\x96\x11\x4d\xd3\xde\x05\x83\xc1\xdc\x8c\x05\x6e\xb7\
\xfb\x8b\xc0\xb2\x60\x9a\x06\x0c\xd3\x80\x99\x33\x30\x91\xf8\x00\
\x45\x56\xc8\x9a\xd5\xeb\xa4\x54\x2a\xd5\xac\xc8\x0f\x37\x25\x6b\
\xdd\x67\x27\x27\x92\x67\x42\xa1\x50\x3c\x99\x4c\xbe\x0b\x06\x83\
\x05\x13\x57\xb0\x07\x7e\xbf\x5f\x61\x8c\xc1\xe2\xd6\x77\x78\x59\
\x99\x08\x2a\x52\x10\x42\x90\x4a\x7f\x82\x62\x93\x85\x2d\x9b\x9b\
\xcb\x03\x81\xc6\xbd\xd5\x0b\xe6\x87\xe7\x57\x39\xf7\x35\x34\x34\
\xac\x01\x40\x4a\x0a\x74\x5d\x57\x58\x86\xc1\xb2\xac\x1f\xe0\x94\
\x52\x50\x51\x02\xa5\x14\x04\x04\x96\x65\xc1\xeb\xf5\x89\x3b\xb6\
\xef\xaa\xc8\xe5\xcc\x36\x41\xc0\xfa\x68\x34\x5a\x55\xb2\x45\xba\
\xae\x2b\xbd\xf7\x18\x38\xb7\x8a\xc2\xa9\x48\x21\x49\x32\x04\x22\
\x60\x34\x1e\xcb\xdf\xed\x8b\x4c\xbb\x2a\x5d\xa7\x03\x81\xc6\x41\
\x4d\xd3\x26\x4a\x0a\x34\x4d\x93\x19\x63\x20\x44\x28\x80\x4b\x54\
\x42\xb9\x24\x63\x32\x91\xe0\xdd\xdd\x5d\xa6\x6a\xb7\x5f\xdf\xbd\
\x73\xcf\x35\x55\x55\x07\x01\x3c\x07\x50\xb0\x8c\xc5\x36\x59\xfc\
\x22\x20\xdf\xe1\x12\x95\x60\x53\x54\x30\xc6\xf8\x85\xae\xce\x7c\
\x26\xc3\x06\x9a\xb7\x6e\xbb\xe8\x76\xbb\x9f\x02\x78\x0a\x20\x53\
\x84\xf3\x4b\x01\x65\x8c\x41\x10\x04\x50\x51\x82\x5d\x75\x80\x73\
\xe0\xc6\xcd\x70\xee\xf5\xeb\x91\xd8\x86\x8d\x9b\xcf\xad\x58\xbe\
\xe2\x09\x80\x47\x00\x26\x7f\x05\x2e\x59\x01\x15\x29\xec\x6a\x05\
\xa2\xd1\x27\xb9\x3b\xbd\x91\xa9\xc0\xda\xc6\xce\x83\x07\x0e\x3d\
\x00\xd0\x0f\x60\xac\x14\xf8\xb7\x02\x41\x10\x30\xfc\xf2\x85\x75\
\xf9\xca\x25\xa3\xae\x6e\xd9\xb5\xc3\x6d\xed\x77\x28\xa5\x03\x00\
\x86\x50\xa4\xcf\xb3\x15\x98\x9a\xb6\xe0\x4d\x7f\xff\xc3\x57\xad\
\xfb\x0f\xdc\x70\x3a\x9d\x03\x00\x1e\x03\x30\x66\x03\xfe\x16\xa4\
\xc8\x2b\xbc\x14\xc0\x2a\x00\x53\x00\xee\x03\x48\xce\x05\xfc\x3b\
\xc1\x1f\x8d\x7f\xff\x4f\xfe\x0c\xd4\xda\x57\xdf\x81\x0c\x47\x3c\
\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x01\xd5\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x01\x33\x49\x44\x41\
\x54\x48\x89\xed\x94\x31\x4e\xc3\x40\x10\x45\xdf\xd8\x4b\xa2\x70\
\x10\x8e\x40\xc5\x19\x38\x06\x1d\x17\x70\x83\x68\x72\x13\x1a\x0e\
\x40\x85\xb8\x00\x48\x54\x14\x94\x54\x88\xd4\x48\x01\xb3\x3b\x9f\
\x62\x63\x12\x8c\x49\x4c\x61\xa4\x48\x99\xc2\xbb\xde\xb1\xff\x9b\
\xd9\xd9\x1d\x93\xc4\x90\x56\x0c\xaa\xbe\x03\xec\x00\xdb\x01\x08\
\xed\x85\xc3\x93\x8b\x73\x77\xaf\xdc\x3d\x48\x8e\x24\xe4\x42\x12\
\x34\xef\x12\xf2\xe5\x1c\x79\x2c\xcc\xa6\x0f\x97\xa7\x67\x1b\x01\
\x31\xc5\xea\xf8\xe8\x20\x4c\xc6\x01\x09\x24\xe1\x02\x91\x41\x0e\
\xc8\x05\xca\x73\x77\xf1\x3a\xaf\xc3\xd5\xcd\x7d\x05\x6c\x06\x78\
\x4c\xe1\xad\x8e\x5c\xdf\x3d\x91\x9a\x68\x25\x24\x30\x33\xcc\x00\
\xf2\x68\x66\x80\x31\xde\x2b\xf1\xe4\x3f\xb4\xba\x01\x9e\xe2\xed\
\xe3\x2c\xec\x4f\x46\x98\x19\xca\x72\x00\xc8\xf2\x23\x8b\x43\x6e\
\x63\x46\x4c\x11\x79\x8a\xfd\x00\xf2\xe9\xcb\xf3\xac\x92\x14\x72\
\xe4\xfe\x55\x83\xdf\x6a\x82\x14\xcb\xb2\x9c\x76\x01\xac\xdd\x4d\
\xad\xc9\xfb\xef\x26\x75\xb4\xe6\x6f\x00\x33\x2b\xc8\x47\x37\xb0\
\x3c\xc2\xeb\x60\xcd\xcf\x0e\x44\xc0\x25\xf9\xea\x07\xed\x2d\x32\
\x60\x04\x4c\x16\xbe\x3e\x99\x68\x21\x3e\x07\xde\xdb\xce\xce\xca\
\xaf\xc0\xfa\x5c\x44\x5f\xe7\x6c\x03\x1c\xa8\x17\x51\x15\xf4\xcf\
\xc0\x81\x8f\x2e\xd8\xff\x16\x79\x08\xdb\xfe\x6e\x3a\x38\xe0\x13\
\xe5\xa9\xcb\x69\x8e\xe9\xaa\x64\x00\x00\x00\x00\x49\x45\x4e\x44\
\xae\x42\x60\x82\
\x00\x00\x02\x14\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x01\x72\x49\x44\x41\
\x54\x48\x89\xed\x95\xcd\x8a\xd5\x40\x10\x46\x4f\x55\xa7\x2e\xb9\
\x23\x77\x74\x06\x6e\x56\x4d\x20\x24\x1b\x1f\x42\x10\xdc\x8b\x0b\
\xc1\x27\x73\x7c\x86\x01\x17\x32\x6f\x30\x20\xbe\x82\x7b\x97\xfe\
\x6c\x06\xdc\xa4\x92\x6e\x17\x5e\x06\x95\x24\xe6\x82\xb3\x18\xf0\
\xdb\x34\x74\xc1\x39\x14\x4d\xf3\x49\xce\x99\xbb\x8c\xde\x29\xfd\
\xbf\x60\x4d\x8a\xa9\x4b\x11\x79\x30\x37\x5b\xc8\x90\x73\xfe\xbe\
\x4a\xb0\xdb\xed\xca\xb7\xef\x2e\x3f\x0a\xec\xd7\x90\x33\x7c\x79\
\xf9\xe2\xd5\x63\x60\x9d\xa0\x69\x9a\xad\xc0\xfe\xe9\x93\x67\xe4\
\x9c\x49\x29\x91\x72\xfa\x79\xa6\x11\x44\x50\x51\x44\x04\x55\xe5\
\xfd\x87\xeb\x7d\xd3\x34\xdb\x29\xd6\xa4\x20\xc6\x78\x32\xf8\x40\
\xca\x99\xaf\xdf\x3e\xe3\xde\xd3\x7b\x8f\x0f\x3d\x21\x14\x58\x61\
\x98\x19\x56\x6c\x38\x7b\x74\xce\xe0\x03\x31\xc6\x93\x29\xd6\xe4\
\x23\xb7\x6d\xbb\xed\xdd\x49\x69\x5c\x84\x9b\x19\x2a\x4a\xef\x4e\
\xdb\xb6\x93\x1b\x4c\x0a\x62\x8c\x5b\x77\x67\x1c\xc7\x45\xb8\x15\
\x86\xa8\xe2\xee\xc4\x18\xd7\x0b\xba\xae\xbb\x15\x2c\xc1\xcd\x36\
\xe8\x41\xd0\x75\xdd\x7a\x41\x5d\xd7\x07\xc1\xb0\x08\x2f\x0a\x23\
\x68\xc0\xdd\xa9\xeb\xfa\x78\x01\x22\x8b\xf0\x8d\x6d\xc8\x39\x1f\
\x2f\xa8\xaa\xaa\xf4\xde\x11\x91\xbf\xc2\x01\xbc\x77\xaa\xaa\x2a\
\xa7\x58\x73\xbf\xb5\x70\x77\x54\x64\x11\x7e\x2b\x70\x9f\x65\xcd\
\x09\xcc\xdd\x51\x55\x4e\x77\x0f\x09\x1a\xd0\x10\x08\x1a\x08\x21\
\xf0\x67\x87\x1c\x04\x76\xd4\x06\x41\xc3\xcd\xc5\x9b\xd7\xa7\x33\
\xf3\xdf\x52\x96\xe5\xcd\x1c\x4b\x66\x1a\xed\x39\x50\xaf\x81\xff\
\x92\x4f\xc0\xd5\x5a\xc1\x3f\xcb\xfd\x2f\x9c\xfb\x2f\xf8\x01\xb0\
\x03\xa7\x1c\x71\x31\x69\x27\x00\x00\x00\x00\x49\x45\x4e\x44\xae\
\x42\x60\x82\
\x00\x00\x03\xa0\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\xfe\x49\x44\x41\
\x54\x48\x89\xed\x95\x4f\x68\x14\x57\x1c\xc7\xbf\x33\xfb\x76\xde\
\xcc\x66\x33\xe8\x6e\x76\x5b\x77\x66\xc7\xe8\x0c\xec\x61\x97\xac\
\x42\x88\x49\x43\xbb\x6d\x02\xbd\x84\xfc\x87\x15\x0f\x2a\xe4\xe0\
\xc5\x20\x12\x24\x37\x91\x1c\x44\x10\x4f\x85\x5e\x03\xc6\x2a\xa5\
\xb4\x6a\x35\x69\xa1\xa5\x25\x14\xda\xde\x7a\x08\xe9\x25\x9a\x9b\
\x78\x30\xb0\xc6\xa8\xd9\xb7\xf3\xdb\xdd\xe7\xc1\xdd\x75\x35\xc6\
\x9c\x02\x22\x3e\xf8\x9d\x3e\x3f\xbe\x9f\xf7\x83\x1f\xef\x29\x52\
\x4a\xec\xe6\x51\x77\x35\xfd\xa3\xe0\xbd\x10\x30\x00\x50\x14\x45\
\x37\x4d\x33\x24\xa5\x54\x14\x45\x91\x1b\x1b\x1b\x9b\x52\x4a\xf1\
\x66\xb3\xa2\x28\x6a\x2c\x16\x0b\x55\x2a\x15\xb5\x50\x28\x08\x29\
\xa5\xff\x36\x5e\x2a\x95\xb4\x46\x86\x94\x12\xd9\x6c\xd6\xfa\xed\
\x8f\x5f\x64\xbd\xb2\xd9\xac\x25\xa5\x44\x73\xa5\x52\xa9\xd6\xf1\
\xf1\xf1\x83\x3f\xdd\xfa\xfe\x9b\x5f\x7f\x9f\x5f\x4a\xa5\x52\x89\
\x66\x9e\x4e\xa7\xc3\xcd\xbc\x9e\xc1\x00\xc0\xb2\xac\x16\xa2\x32\
\xbe\xe8\xfd\x12\x7f\xfd\xbd\x08\xcb\xb2\x5a\xea\xb7\x1a\x1a\x1a\
\x0a\x05\x02\x81\xf8\xb9\xe9\xa9\x81\x7d\xd6\xa7\x33\xee\x01\xcf\
\xbc\xbf\xba\x12\x74\x5d\x37\xdc\xcc\xcf\x4e\x9d\x79\x8d\xd7\x33\
\x18\x00\xb8\xae\x6b\x10\x11\x36\x9e\x3e\x01\x11\xc1\x75\x5d\x23\
\x9f\xcf\x6b\x96\x65\x25\x72\x7d\xb9\x43\x4e\x32\x31\x63\x27\x93\
\xa9\x8e\xcc\x21\xae\x73\x03\xcb\xcb\x4b\x70\x5d\xd7\x98\x9c\x9c\
\xdc\x9f\xeb\xcb\x1d\x76\x92\x89\x19\xdb\x49\xa6\x3a\xd2\x35\xfe\
\xff\x4b\xde\x10\xd8\xb6\x6d\x10\x11\x58\x80\x81\x88\x60\xdb\xb6\
\xe1\x79\x5e\xef\xde\x48\xf8\x74\x34\xda\x36\xd8\xdd\xdd\x1b\xe4\
\x9c\x2b\xbe\x5f\x82\xa6\x71\x08\x21\xd0\xde\xde\xde\x16\x8b\xef\
\x39\x1f\x6d\x6b\x1b\xec\x3e\xb2\x95\xdb\xb6\xfd\x4a\xe0\x79\x9e\
\x51\xa2\x4d\x30\xf6\x52\xf0\xc9\xbe\xe8\x28\xd7\xb4\xc9\x9e\x9e\
\xcf\xf5\x68\x34\xaa\xfa\x7e\x09\xe5\x72\x19\x9c\xeb\x08\xa8\x01\
\x08\x21\x90\xb0\x63\x77\x7a\xba\xb7\xe7\x9e\xe7\x19\x40\x6d\x4d\
\x1d\xc7\x31\x88\x08\x95\x6a\x05\x44\x04\x40\x99\x1e\x1d\xc9\x87\
\x4c\xb3\x55\xdd\x2c\x3e\x07\x63\x0c\x9c\xeb\xd0\xb9\x0e\x55\x55\
\x11\x0c\x6a\x18\x1d\xde\x9e\x8b\xa2\x80\xe3\x38\x5b\x05\x3e\xf9\
\x20\x22\x84\xc3\xe1\x6f\xe7\xae\xcf\x16\x1f\xaf\xaf\x57\x5b\x5b\
\x4c\x70\xae\x83\x6b\x1c\xaa\x1a\x00\x00\xac\xad\x3d\xc2\xbb\xb8\
\x10\xaf\x04\x0c\x00\xe2\xf1\xb8\x4e\x3e\x81\xc8\x07\xf9\x84\xf1\
\xd1\xfc\xbf\x85\x42\xe1\xbf\xbb\xf3\xb7\x8f\x55\xaa\xd5\xdc\xc8\
\xd0\x18\xd3\xf6\x72\xa5\xbe\x59\x42\x08\x4c\x8c\x9c\x3a\x73\x77\
\xfe\xf6\xd1\x4a\xb5\x9a\x1b\x19\x1e\x63\xda\x9e\xd7\x79\x3c\x1e\
\xd7\x1b\x13\x00\x60\xcd\x13\x00\x60\x91\x48\xe4\x87\x93\x27\x26\
\x2e\x75\x75\x76\x5d\xb8\x7a\x6d\x76\xf5\xe6\xad\x1f\xa9\x58\x2c\
\x36\x02\x22\x91\x08\x9d\x3c\x31\x71\xb1\xab\xb3\xeb\xc2\xd5\xb9\
\xad\xbc\x7e\x79\x56\x13\x04\x89\x08\x54\x6e\x08\x82\x00\x9e\x01\
\xf8\x33\x93\xe9\x58\xc9\x64\x3a\xee\x2d\x2c\xfc\xfc\xd5\xe5\x2b\
\x17\x8f\xf7\xf7\x7d\x6d\x08\x21\x58\xad\x67\x71\x07\xde\x10\x54\
\x89\x08\xf3\x77\x16\xea\x53\x56\x9b\x5e\x80\x07\x00\x6e\x0e\x0c\
\x0c\xdf\xcb\xe5\xfa\x97\xbe\xbb\x31\x37\xdc\x1a\x36\xd3\x00\xca\
\x35\xfe\xb0\xc6\x57\xde\xc6\x95\xda\x8f\x96\x01\xf0\x19\x00\x0d\
\x80\x0f\xe0\x1f\x00\xcb\xd8\x7a\x42\x00\x7a\x00\x98\x00\x96\x00\
\xac\xee\xc4\x95\x8f\x5f\xe6\x87\x2f\x78\x01\x3b\x45\x80\x60\x2f\
\xb0\xe2\xfb\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x29\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\x87\x49\x44\x41\
\x54\x48\x89\xed\x95\xd1\x4b\x53\x51\x1c\xc7\xbf\xe7\x7a\x77\xce\
\xe6\x96\xd3\x3b\xbb\xa2\x37\x6c\x7a\x07\x13\x75\xed\x21\xf2\x41\
\x42\x66\xa6\x4f\x81\x6d\x82\x0f\x41\x41\x60\x6f\x61\x14\x15\xbd\
\xe9\xdf\xe0\x43\x04\x81\x2f\x3d\x54\x06\x96\xc3\x10\x06\x61\x56\
\xa6\x05\x23\x6b\xa6\x04\x81\x38\xbd\xb3\x82\x48\xc3\xdc\x31\xef\
\x76\x7b\x69\x32\xb6\xdd\xf9\x24\x54\xf4\x85\xf3\xf4\x81\xdf\x87\
\x1f\xe7\xfc\xce\x8f\x18\x86\x81\xfd\x8c\xb0\xaf\xd5\xff\x0b\xfe\
\x2c\x01\x21\xc4\xea\x74\x3a\x25\x59\x96\x1d\x84\x90\x3c\x31\x21\
\x84\xba\x5c\xae\x32\x33\x6e\x1a\xc3\x30\x60\x18\x06\xfc\x7e\xbf\
\x32\x11\x19\x7f\xf7\xe0\xe1\xbd\xa1\x9e\x9e\x9e\xfa\xa6\xa6\x26\
\x47\x86\x19\x86\x01\xaf\xd7\x5b\x93\xcd\xbd\x5e\xef\x81\x6c\x6e\
\x76\xc4\x8c\x48\x51\x14\xbb\xae\xef\xf8\x1a\x1b\x1a\x1b\xce\x5f\
\x38\x7b\x66\x4d\xfb\x3c\x10\x0c\x06\x1f\xa7\x52\xa9\x2f\xe1\x70\
\x78\x4b\x55\x55\x47\x31\x6e\xd6\x00\xc9\x0c\x5a\x7f\x7f\xbf\xbf\
\xad\xbd\x75\xae\xfb\x54\x08\xc9\x64\x12\xf3\x0b\xb1\x6d\x4d\x5b\
\xf9\x10\x5f\x49\x0c\x2c\x7d\x5c\x7a\x23\x08\x42\xb9\x19\x5f\x5d\
\x5e\x9d\xd3\x34\x2d\x31\x32\x32\xf2\x33\x57\x50\x32\x38\x38\x08\
\x00\x88\xc5\x62\x75\x36\x3b\xeb\x53\x55\x0f\xb4\xb5\x38\xea\xdc\
\xaa\x58\xef\xf6\xc8\x7c\x7b\x2b\x24\x55\x56\xb8\xa9\xc8\x16\x98\
\xcd\x72\xae\x10\x2f\x97\xca\xdc\x72\x65\xd5\xa7\xe9\xe9\xe9\x54\
\x24\x12\xd9\x0c\x04\x02\xbb\xdf\xc3\xee\x65\x79\x3c\x1e\x1b\x4f\
\x72\x00\x80\x28\x5a\xb0\x95\xfc\x01\x52\x42\xc8\xc9\x13\x5d\xb4\
\x23\xd0\x19\x54\x0e\x55\x85\x39\x37\xe1\xed\x9d\xc1\xaa\x6a\xd7\
\xb8\xeb\xa0\xf3\xa2\xcf\xe7\x6b\x01\x40\xf2\x04\xb5\xb5\xb5\x36\
\xce\x39\x08\x08\x18\x63\xb0\x52\x2b\x18\x65\xa0\x94\xa1\xa6\x46\
\x11\x42\xc1\xde\x52\x8b\x48\x0b\xf3\x6a\x45\x08\x9d\xee\x2d\x05\
\xc8\x75\x41\x40\x5b\x34\x1a\x75\x65\xea\x8a\xd9\x82\xa7\xcf\x38\
\x04\x41\x00\xb5\x30\x50\xc6\xc0\xa8\x15\xba\xae\x23\x91\xd0\xd2\
\x91\x27\x13\xdb\xeb\xdf\xd6\x6d\xc5\x78\x45\xb9\x34\xdc\xda\x7a\
\xfc\xad\x2c\xcb\x5f\xf3\x04\xb2\x2c\x5b\x39\xe7\x20\x84\x80\x52\
\x0a\x1b\x2b\xc5\xc6\xc6\xba\xf1\x28\x3c\xaa\x97\x08\xc2\x54\xa8\
\xbb\xf7\xfe\xcd\x5b\x43\xb7\x8b\xf0\xbb\x92\x24\x45\x01\xcc\x03\
\x30\xf2\x04\x00\x44\xce\x39\x18\x65\x48\xa7\xd2\x18\x0b\x8f\xee\
\xc4\x57\xe2\xcb\x9d\x1d\x5d\xc3\xcd\xcd\x47\x66\x00\x1c\x2e\xc2\
\x5f\x01\x78\x0d\x60\x33\xf7\x15\x65\x0b\x2c\x9c\x73\x3c\x7f\x31\
\xa5\x4f\x4e\x4d\x26\x5b\x8e\x1e\xbb\x73\xf9\xd2\xd5\x49\x00\x2f\
\x01\x24\x00\xf4\x99\xf0\x59\x00\xab\xb9\x85\x0b\x09\x74\xbb\xdd\
\x1e\x5f\x5c\x5c\x7c\x7f\xed\xca\x8d\x31\x87\xc3\x31\xf3\xbb\xdd\
\xb4\x09\x9f\x05\x10\xcb\xe2\x05\x43\xb2\x36\x9a\x0a\xe0\x08\x80\
\xef\x00\x66\x00\xe4\x4e\xe7\x5e\x7c\x4f\xc1\xbe\xe4\x1f\xda\x07\
\x7f\xad\xe0\x17\x7b\x9d\x63\xcf\x7c\x92\xfe\x92\x00\x00\x00\x00\
\x49\x45\x4e\x44\xae\x42\x60\x82\
\x00\x00\x03\x0b\
\x89\
\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\
\x00\x00\x18\x00\x00\x00\x18\x08\x06\x00\x00\x00\xe0\x77\x3d\xf8\
\x00\x00\x00\x04\x73\x42\x49\x54\x08\x08\x08\x08\x7c\x08\x64\x88\
\x00\x00\x00\x09\x70\x48\x59\x73\x00\x00\x0d\xd7\x00\x00\x0d\xd7\
\x01\x42\x28\x9b\x78\x00\x00\x00\x19\x74\x45\x58\x74\x53\x6f\x66\
\x74\x77\x61\x72\x65\x00\x77\x77\x77\x2e\x69\x6e\x6b\x73\x63\x61\
\x70\x65\x2e\x6f\x72\x67\x9b\xee\x3c\x1a\x00\x00\x00\x13\x74\x45\
\x58\x74\x54\x69\x74\x6c\x65\x00\x4f\x70\x74\x69\x63\x61\x6c\x20\
\x44\x72\x69\x76\x65\x3e\x67\xba\x0c\x00\x00\x02\x69\x49\x44\x41\
\x54\x48\x89\xdd\x95\x3d\x6b\x14\x51\x14\x86\x9f\x33\x73\x67\x77\
\xb2\x49\xc8\x07\xf8\x13\x04\xd1\x5a\x6d\x84\x14\x96\xda\xa4\x10\
\x85\x14\x76\x62\xa1\xa5\x08\xdb\x48\x9a\x2d\x05\x41\x6c\xac\x52\
\x58\xc4\x4a\xc1\x26\xda\x28\x6a\xe1\x47\x40\x25\x2a\xa6\x09\x62\
\x90\x18\x44\x4c\xcc\xc7\xec\xec\xbd\xe7\x58\xec\x2c\x26\xbb\x6b\
\xd8\x10\xd3\x78\x9a\x81\x99\x7b\xdf\xe7\xbc\xe7\xcc\x3d\x57\xcc\
\x8c\xfd\x8c\x68\x5f\xd5\xff\x0b\x80\xeb\x65\xd1\x89\x4b\xd3\x93\
\x8d\x46\xa8\xaa\x99\x8b\x44\x7c\x92\xc4\xb5\x67\x37\xcf\x5e\xfb\
\x67\x80\xbc\x11\xaa\x57\x26\x8e\xbb\x92\x8b\x98\x5f\xfc\xe9\xa6\
\x1f\xcd\x55\x81\x9e\x00\x3d\x95\xc8\xcc\x9c\x08\xbc\xfa\xf4\x0d\
\x1f\x94\xe0\x43\x4f\x89\x41\x8f\x0e\x34\x04\x36\x33\xcf\xea\x5a\
\x1d\x0d\x8a\x69\xe8\x55\xbf\x47\x80\x2a\x59\xbd\xc1\xca\x7a\x8e\
\x99\xa1\x61\x0f\x80\x63\x17\xee\x4c\xaa\x6a\x55\x55\x9d\x99\x62\
\x66\x0c\xa4\xa5\x6c\x3d\x6b\xa4\xab\x6b\x9b\x88\x19\x2e\x8a\xb2\
\x23\xe7\x6e\x99\x99\x61\x66\x60\xea\x23\x91\xda\xfb\xbb\x97\x3b\
\xfa\xd2\x01\xf0\xc1\x57\xc7\xc7\x0e\xb9\xb4\x14\x03\x60\x66\x04\
\x25\xfd\xb0\xf0\x9d\x95\xb5\x3a\xf5\x3c\x70\x7a\xec\x70\x5a\x2e\
\xc5\x18\x60\x06\xbf\x36\x32\x77\x6f\x66\xb6\x6b\xe3\x3b\x00\xea\
\x83\xcb\x72\xcf\xcc\x8b\x05\xd4\x9a\x00\x35\x45\x15\x44\x84\xf5\
\xac\xc1\xc3\xd7\x9f\x89\x44\x10\x11\x40\x18\x1d\x4a\xd1\xa0\x5d\
\xcb\xdd\x09\xd0\xe0\x67\xe7\x97\xdd\xc8\x50\x05\x91\xe6\x3b\x41\
\xc8\xf2\xc0\x46\xee\xe9\x2f\x27\x54\x52\x57\x88\x37\xa1\xb9\xf7\
\x98\x06\xdf\x1b\xc0\xb4\xb6\xf8\x65\xa9\x6a\x66\xae\x59\x63\x25\
\x8e\x5c\x76\xe6\xd4\xd1\xf4\xf9\xdc\x57\x86\x07\xfb\x78\xfb\xe6\
\x63\x96\xe7\x79\x4a\xd1\x23\xcc\x7c\x1c\xc7\xb5\x6e\x00\x69\x9f\
\xa6\xd2\xf2\xbd\x25\x0e\x8e\x5f\x0f\x17\x27\x4e\xf2\xf8\xdd\x12\
\x23\x83\x25\x9e\x3e\x79\xc9\xc2\x83\xab\x71\x9b\x96\x59\x97\xd1\
\xbc\xcd\x81\x88\x44\x34\x0f\x9f\x2b\x9e\x02\xa0\x41\x49\x12\x47\
\x39\x2d\x51\x2e\x27\x98\x2a\x40\x5f\x4b\x18\x50\xc0\x8b\x88\x9a\
\x99\xee\x54\x22\x01\x4a\xc5\xe6\x16\x24\x56\x0d\xb8\x24\x21\x4d\
\x13\xca\xa5\x72\x6b\xed\x08\x10\x5a\xe2\xc0\x26\x50\x6f\x77\xb0\
\xd3\xa8\x88\x80\x18\xa8\x98\x59\xa8\xe7\x81\x03\xc3\xfd\x84\xe6\
\xef\x14\x80\x4a\xf1\x7d\xc7\x71\xd3\xee\x40\x81\xbc\xb0\x5d\x07\
\x12\xc0\xd9\xc6\xf2\xd4\x8d\xdb\xf7\xcf\x63\x16\x23\x12\x6c\x63\
\x79\xaa\x58\xb7\x0e\x34\x0a\x27\x8d\x62\xff\xf6\x92\xec\xd0\x64\
\x29\x32\x1c\x00\x46\xb7\x64\xac\x85\xf0\x0f\x60\xad\x10\x6f\x9e\
\xb9\x2e\x4d\xee\x00\xb4\xc1\x5a\x0d\x2f\xf3\xa7\x1c\x46\xb3\xe6\
\x75\xc0\xb7\x37\x75\x57\x80\x2e\x8e\x5a\xf1\xd7\x8c\x77\x0d\xd8\
\x6b\xec\xfb\x9d\xfc\x1b\x2d\x09\x44\x60\x7c\x30\xf3\xc1\x00\x00\
\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82\
"

qt_resource_name = "\
\x00\x05\
\x00\x6f\xa6\x53\
\x00\x69\
\x00\x63\x00\x6f\x00\x6e\x00\x73\
\x00\x17\
\x0d\x33\x2b\xc7\
\x00\x6d\
\x00\x65\x00\x64\x00\x69\x00\x61\x00\x2d\x00\x73\x00\x65\x00\x65\x00\x6b\x00\x2d\x00\x62\x00\x61\x00\x63\x00\x6b\x00\x77\x00\x61\
\x00\x72\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x1b\
\x0b\x75\xca\xe7\
\x00\x6d\
\x00\x65\x00\x64\x00\x69\x00\x61\x00\x2d\x00\x73\x00\x6b\x00\x69\x00\x70\x00\x2d\x00\x62\x00\x61\x00\x63\x00\x6b\x00\x77\x00\x61\
\x00\x72\x00\x64\x00\x2d\x00\x72\x00\x74\x00\x6c\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x14\
\x02\x93\x52\xe7\
\x00\x65\
\x00\x6d\x00\x62\x00\x6c\x00\x65\x00\x6d\x00\x2d\x00\x69\x00\x6d\x00\x70\x00\x6f\x00\x72\x00\x74\x00\x61\x00\x6e\x00\x74\x00\x2e\
\x00\x70\x00\x6e\x00\x67\
\x00\x18\
\x0f\xa4\x86\x47\
\x00\x6d\
\x00\x65\x00\x64\x00\x69\x00\x61\x00\x2d\x00\x70\x00\x6c\x00\x61\x00\x79\x00\x62\x00\x61\x00\x63\x00\x6b\x00\x2d\x00\x73\x00\x74\
\x00\x61\x00\x72\x00\x74\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0f\
\x02\x30\x8b\xe7\
\x00\x6c\
\x00\x69\x00\x73\x00\x74\x00\x2d\x00\x72\x00\x65\x00\x6d\x00\x6f\x00\x76\x00\x65\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x17\
\x09\x10\x6a\x47\
\x00\x6d\
\x00\x65\x00\x64\x00\x69\x00\x61\x00\x2d\x00\x70\x00\x6c\x00\x61\x00\x79\x00\x62\x00\x61\x00\x63\x00\x6b\x00\x2d\x00\x73\x00\x74\
\x00\x6f\x00\x70\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x17\
\x0d\x4e\xc5\x87\
\x00\x6d\
\x00\x65\x00\x64\x00\x69\x00\x61\x00\x2d\x00\x73\x00\x6b\x00\x69\x00\x70\x00\x2d\x00\x62\x00\x61\x00\x63\x00\x6b\x00\x77\x00\x61\
\x00\x72\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x16\
\x01\xd6\x37\x67\
\x00\x6d\
\x00\x65\x00\x64\x00\x69\x00\x61\x00\x2d\x00\x73\x00\x65\x00\x65\x00\x6b\x00\x2d\x00\x66\x00\x6f\x00\x72\x00\x77\x00\x61\x00\x72\
\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
\x00\x0c\
\x09\xc6\x19\x27\
\x00\x6c\
\x00\x69\x00\x73\x00\x74\x00\x2d\x00\x61\x00\x64\x00\x64\x00\x2e\x00\x70\x00\x6e\x00\x67\
"

qt_resource_struct = "\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x01\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x09\x00\x00\x00\x02\
\x00\x00\x01\x70\x00\x00\x00\x00\x00\x01\x00\x00\x16\x82\
\x00\x00\x00\xe4\x00\x00\x00\x00\x00\x01\x00\x00\x0e\xed\
\x00\x00\x00\x80\x00\x00\x00\x00\x00\x01\x00\x00\x06\x70\
\x00\x00\x01\x08\x00\x00\x00\x00\x00\x01\x00\x00\x10\xc6\
\x00\x00\x01\xa2\x00\x00\x00\x00\x00\x01\x00\x00\x19\xaf\
\x00\x00\x00\x44\x00\x00\x00\x00\x00\x01\x00\x00\x03\x22\
\x00\x00\x00\x10\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\
\x00\x00\x01\x3c\x00\x00\x00\x00\x00\x01\x00\x00\x12\xde\
\x00\x00\x00\xae\x00\x00\x00\x00\x00\x01\x00\x00\x0b\x6c\
"
def qInitResources():
    QtCore.qRegisterResourceData(0x01, qt_resource_struct, qt_resource_name, qt_resource_data)

def qCleanupResources():
    QtCore.qUnregisterResourceData(0x01, qt_resource_struct, qt_resource_name, qt_resource_data)

qInitResources()
if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    MainWindow = QtGui.QMainWindow()
    ui = Ui_MainWindow()
    ui.setupUi(MainWindow)
    MainWindow.show()
    sys.exit(app.exec_())
